"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewFieldList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactTinyVirtualList = _interopRequireDefault(require("react-tiny-virtual-list"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _field_editor_context = require("../../field_editor_context");
var _field_preview_context = require("../field_preview_context");
var _field_list_item = require("./field_list_item");
var _state_utils = require("../../../state_utils");
require("./field_list.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ITEM_HEIGHT = 40;
const SHOW_MORE_HEIGHT = 40;
const INITIAL_MAX_NUMBER_OF_FIELDS = 7;
/**
 * Escape regex special characters (e.g /, ^, $...) with a "\"
 * Copied from https://stackoverflow.com/a/9310752
 */
function escapeRegExp(text) {
  return text.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
function fuzzyMatch(searchValue, text) {
  const pattern = `.*${searchValue.split('').map(escapeRegExp).join('.*')}.*`;
  const regex = new RegExp(pattern, 'i');
  return regex.test(text);
}
const pinnedFieldsSelector = s => s.pinnedFields;
const currentDocumentSelector = s => s.documents[s.currentIdx];
const PreviewFieldList = ({
  height,
  clearSearch,
  searchValue = ''
}) => {
  const {
    dataView
  } = (0, _field_editor_context.useFieldEditorContext)();
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const pinnedFields = (0, _state_utils.useStateSelector)(controller.state$, pinnedFieldsSelector, _lodash.isEqual);
  const currentDocument = (0, _state_utils.useStateSelector)(controller.state$, currentDocumentSelector);
  const [showAllFields, setShowAllFields] = (0, _react.useState)(false);
  const fieldList = (0, _react.useMemo)(() => dataView.fields.getAll().map(field => {
    const {
      name,
      displayName
    } = field;
    const formatter = dataView.getFormatterForField(field);
    const value = (0, _lodash.get)(currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._source, name);
    const formattedValue = formatter.convert(value, 'html');
    return {
      key: displayName,
      value,
      formattedValue,
      isPinned: false
    };
  }).filter(({
    value
  }) => value !== undefined), [dataView, currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._source]);
  const fieldListWithPinnedFields = (0, _react.useMemo)(() => {
    const pinned = [];
    const notPinned = [];
    fieldList.forEach(field => {
      if (pinnedFields[field.key]) {
        pinned.push({
          ...field,
          isPinned: true
        });
      } else {
        notPinned.push({
          ...field,
          isPinned: false
        });
      }
    });
    return [...pinned, ...notPinned];
  }, [fieldList, pinnedFields]);
  const {
    filteredFields,
    totalFields
  } = (0, _react.useMemo)(() => {
    const list = searchValue.trim() === '' ? fieldListWithPinnedFields : fieldListWithPinnedFields.filter(({
      key
    }) => fuzzyMatch(searchValue, key));
    const total = list.length;
    if (showAllFields) {
      return {
        filteredFields: list,
        totalFields: total
      };
    }
    return {
      filteredFields: list.filter((_, i) => i < INITIAL_MAX_NUMBER_OF_FIELDS),
      totalFields: total
    };
  }, [fieldListWithPinnedFields, showAllFields, searchValue]);
  const hasSearchValue = searchValue.trim() !== '';
  const isEmptySearchResultVisible = hasSearchValue && totalFields === 0;

  // "height" corresponds to the total height of the flex item that occupies the remaining
  // vertical space up to the bottom of the flyout panel. We don't want to give that height
  // to the virtual list because it would mean that the "Show more" button would be pinned to the
  // bottom of the panel all the time. Which is not what we want when we render initially a few
  // fields.
  const listHeight = Math.min(filteredFields.length * ITEM_HEIGHT, height - SHOW_MORE_HEIGHT);
  const toggleShowAllFields = (0, _react.useCallback)(() => {
    setShowAllFields(prev => !prev);
  }, []);
  const renderEmptyResult = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("h3", {
        className: "indexPatternFieldEditor__previewEmptySearchResult__title"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.searchResult.emptyPromptTitle', {
        defaultMessage: 'No matching fields in this data view'
      }))),
      titleSize: "xs",
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: clearSearch,
        "data-test-subj": "clearSearchButton"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.searchResult.emptyPrompt.clearSearchButtonLabel', {
        defaultMessage: 'Clear search'
      })),
      "data-test-subj": "emptySearchResult"
    }));
  };
  const renderToggleFieldsButton = () => totalFields <= INITIAL_MAX_NUMBER_OF_FIELDS ? null : /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewFieldList__showMore"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleShowAllFields,
    flush: "left"
  }, showAllFields ? _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.showLessFieldsButtonLabel', {
    defaultMessage: 'Show less'
  }) : _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.showMoreFieldsButtonLabel', {
    defaultMessage: 'Show more'
  })));
  if (currentDocument === undefined || height === -1) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewFieldList"
  }, isEmptySearchResultVisible ? renderEmptyResult() : /*#__PURE__*/_react.default.createElement(_reactTinyVirtualList.default, {
    style: {
      overflowX: 'hidden'
    },
    width: "100%",
    height: listHeight,
    itemCount: filteredFields.length,
    itemSize: ITEM_HEIGHT,
    overscanCount: 4,
    renderItem: ({
      index,
      style
    }) => {
      const field = filteredFields[index];
      return /*#__PURE__*/_react.default.createElement("div", {
        key: field.key,
        style: style,
        "data-test-subj": "indexPatternFieldList"
      }, /*#__PURE__*/_react.default.createElement(_field_list_item.PreviewListItem, {
        key: field.key,
        field: field,
        toggleIsPinned: controller.togglePinnedField
      }));
    }
  }), renderToggleFieldsButton());
};
exports.PreviewFieldList = PreviewFieldList;