"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsNavPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state_utils = require("../../state_utils");
var _field_preview_context = require("./field_preview_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const docIdSelector = state => {
  const doc = state.documents[state.currentIdx];
  return {
    documentId: doc ? doc._id : undefined,
    customId: state.customId
  };
};
const DocumentsNavPreview = () => {
  const {
    documents: {
      loadSingle,
      loadFromCluster,
      fetchDocError
    },
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const {
    goToPreviousDocument: prev,
    goToNextDocument: next
  } = controller;
  const {
    documentId,
    customId
  } = (0, _state_utils.useStateSelector)(controller.state$, docIdSelector);
  const isInvalid = (fetchDocError === null || fetchDocError === void 0 ? void 0 : fetchDocError.code) === 'DOC_NOT_FOUND';

  // We don't display the nav button when the user has entered a custom
  // document ID as at that point there is no more reference to what's "next"
  const showNavButtons = !customId;
  const onDocumentIdChange = (0, _react.useCallback)(e => {
    const nextId = e.target.value;
    loadSingle(nextId);
  }, [loadSingle]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentIdField.label', {
      defaultMessage: 'Document ID'
    }),
    isInvalid: isInvalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    value: customId || documentId || '',
    onChange: onDocumentIdChange,
    fullWidth: true,
    "data-test-subj": "documentIdField"
  })), customId && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "xs",
    flush: "left",
    onClick: () => loadFromCluster(),
    "data-test-subj": "loadDocsFromClusterButton"
  }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentIdField.loadDocumentsFromCluster', {
    defaultMessage: 'Load documents from cluster'
  })))), showNavButtons && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "documentsNav"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "m",
    onClick: prev,
    iconType: "arrowLeft",
    "data-test-subj": "goToPrevDocButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentNav.previousArialabel', {
      defaultMessage: 'Previous document'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "m",
    onClick: next,
    iconType: "arrowRight",
    "data-test-subj": "goToNextDocButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentNav.nextArialabel', {
      defaultMessage: 'Next document'
    })
  }))))));
};
exports.DocumentsNavPreview = DocumentsNavPreview;