"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultState = exports.convertSampleInput = exports.DefaultFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertSampleInput = (converter, inputs) => {
  let error;
  let samples = [];
  try {
    samples = inputs.map(input => {
      return {
        input,
        output: converter(input)
      };
    });
  } catch (e) {
    error = _i18n.i18n.translate('indexPatternFieldEditor.defaultErrorMessage', {
      defaultMessage: 'An error occurred while trying to use this format configuration: {message}',
      values: {
        message: e.message
      }
    });
  }
  return {
    error,
    samples
  };
};
exports.convertSampleInput = convertSampleInput;
const defaultState = {
  sampleInputs: [],
  sampleConverterType: 'text',
  error: undefined,
  samples: [],
  sampleInputsByType: {}
};
exports.defaultState = defaultState;
class DefaultFormatEditor extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", defaultState);
    (0, _defineProperty2.default)(this, "onChange", (newParams = {}) => {
      const {
        onChange,
        formatParams
      } = this.props;
      onChange({
        ...formatParams,
        ...newParams
      });
    });
  }
  static getDerivedStateFromProps(nextProps, state) {
    const {
      format,
      formatParams,
      onError
    } = nextProps;
    const {
      sampleInputsByType,
      sampleInputs,
      sampleConverterType
    } = state;
    const converter = format.getConverterFor(sampleConverterType);
    const type = typeof sampleInputsByType === 'object' && formatParams.type;
    const inputs = type ? sampleInputsByType[formatParams.type] || [] : sampleInputs;
    const output = convertSampleInput(converter, inputs);
    onError(output.error);
    return output;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
}
exports.DefaultFormatEditor = DefaultFormatEditor;
(0, _defineProperty2.default)(DefaultFormatEditor, "formatId", _constants.formatId);