"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldEditorServices = exports.useFieldEditorContext = exports.FieldEditorProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const fieldEditorContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const FieldEditorProvider = ({
  services,
  dataView,
  links,
  uiSettings,
  fieldTypeToProcess,
  fieldFormats,
  fieldFormatEditors,
  namesNotAllowed,
  existingConcreteFields,
  children,
  fieldName$,
  subfields$
}) => {
  const ctx = (0, _react.useMemo)(() => ({
    dataView,
    fieldTypeToProcess,
    links,
    uiSettings,
    services,
    fieldFormats,
    fieldFormatEditors,
    namesNotAllowed,
    existingConcreteFields,
    fieldName$,
    subfields$
  }), [dataView, fieldTypeToProcess, services, links, uiSettings, fieldFormats, fieldFormatEditors, namesNotAllowed, existingConcreteFields, fieldName$, subfields$]);
  return /*#__PURE__*/_react.default.createElement(fieldEditorContext.Provider, {
    value: ctx
  }, children);
};
exports.FieldEditorProvider = FieldEditorProvider;
const useFieldEditorContext = () => {
  const ctx = (0, _react.useContext)(fieldEditorContext);
  if (ctx === undefined) {
    throw new Error('useFieldEditorContext must be used within a <FieldEditorContext />');
  }
  return ctx;
};
exports.useFieldEditorContext = useFieldEditorContext;
const useFieldEditorServices = () => useFieldEditorContext().services;
exports.useFieldEditorServices = useFieldEditorServices;