"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditorOpener = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("./shared_imports");
var _data_view_editor_lazy = require("./components/data_view_editor_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getEditorOpener = ({
  core,
  searchClient,
  dataViews
}) => options => {
  const {
    uiSettings,
    overlays,
    docLinks,
    notifications,
    http,
    application
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    docLinks,
    http,
    notifications,
    application,
    dataViews,
    overlays,
    searchClient
  });
  let overlayRef = null;
  const openEditor = ({
    onSave,
    onCancel = () => {},
    defaultTypeIsRollup = false,
    requireTimestampField = false,
    allowAdHocDataView = false,
    editData
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveIndexPattern = indexPattern => {
      closeEditor();
      if (onSave) {
        onSave(indexPattern);
      }
    };
    overlayRef = overlays.openFlyout((0, _shared_imports.toMountPoint)( /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_data_view_editor_lazy.DataViewEditorLazy, {
      onSave: onSaveIndexPattern,
      onCancel: () => {
        closeEditor();
        onCancel();
      },
      editData: editData,
      defaultTypeIsRollup: defaultTypeIsRollup,
      requireTimestampField: requireTimestampField,
      allowAdHocDataView: allowAdHocDataView,
      showManagementLink: Boolean(editData && editData.isPersisted())
    }))), {
      theme$: core.theme.theme$
    }), {
      hideCloseButton: true,
      size: 'l'
    });
    return closeEditor;
  };
  return openEditor(options);
};
exports.getEditorOpener = getEditorOpener;