"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PER_PAGE_STORAGE_KEY = exports.IndicesList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PER_PAGE_INCREMENTS = [5, 10, 20, 50];
const PER_PAGE_STORAGE_KEY = 'dataViews.previewPanel.indicesPerPage';
exports.PER_PAGE_STORAGE_KEY = PER_PAGE_STORAGE_KEY;
class IndicesList extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "pager", void 0);
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "resetPageTo0", () => this.onChangePage(0));
    (0, _defineProperty2.default)(this, "onChangePage", page => {
      this.pager.goToPageIndex(page);
      this.setState({
        page
      });
    });
    (0, _defineProperty2.default)(this, "onChangePerPage", perPage => {
      this.pager.setItemsPerPage(perPage);
      this.setState({
        perPage
      });
      this.resetPageTo0();
      this.closePerPageControl();
      this.storage.set(PER_PAGE_STORAGE_KEY, perPage);
    });
    (0, _defineProperty2.default)(this, "openPerPageControl", () => {
      this.setState({
        isPerPageControlOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closePerPageControl", () => {
      this.setState({
        isPerPageControlOpen: false
      });
    });
    this.storage = new _public.Storage(localStorage);
    this.state = {
      page: 0,
      perPage: this.storage.get(PER_PAGE_STORAGE_KEY) || PER_PAGE_INCREMENTS[1],
      isPerPageControlOpen: false
    };
    this.pager = new _eui.Pager(props.indices.length, this.state.perPage, this.state.page);
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.indices.length !== this.props.indices.length) {
      this.pager.setTotalItems(nextProps.indices.length);
      this.resetPageTo0();
    }
  }
  renderPagination() {
    const {
      perPage,
      page,
      isPerPageControlOpen
    } = this.state;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.openPerPageControl
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.pagingLabel",
      defaultMessage: "Rows per page: {perPage}",
      values: {
        perPage
      }
    }));
    const items = PER_PAGE_INCREMENTS.map(increment => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: increment,
        icon: "empty",
        onClick: () => this.onChangePerPage(increment)
      }, increment);
    });
    const pageCount = this.pager.getTotalPages();
    const paginationControls = pageCount > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      pageCount: pageCount,
      activePage: page,
      onPageClick: this.onChangePage
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "customizablePagination",
      button: button,
      isOpen: isPerPageControlOpen,
      closePopover: this.closePerPageControl,
      panelPaddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items
    }))), paginationControls);
  }
  highlightIndexName(indexName, query) {
    const {
      isExactMatch
    } = this.props;
    if (!query) {
      return indexName;
    }
    if (isExactMatch(indexName)) {
      return /*#__PURE__*/_react.default.createElement("strong", null, indexName);
    }
    const queryAsArray = query.split(',').map(q => q.trim()).filter(Boolean);
    let queryIdx = -1;
    let queryWithoutWildcard = '';
    for (let i = 0; i < queryAsArray.length; i++) {
      const queryComponent = queryAsArray[i];
      queryWithoutWildcard = queryComponent.endsWith('*') ? queryComponent.substring(0, queryComponent.length - 1) : queryComponent;
      queryIdx = indexName.indexOf(queryWithoutWildcard);
      if (queryIdx !== -1) {
        break;
      }
    }
    if (queryIdx === -1) {
      return indexName;
    }
    const preStr = indexName.substring(0, queryIdx);
    const postStr = indexName.substr(queryIdx + queryWithoutWildcard.length);
    return /*#__PURE__*/_react.default.createElement("span", null, preStr, /*#__PURE__*/_react.default.createElement("strong", null, queryWithoutWildcard), postStr);
  }
  render() {
    const {
      indices,
      query,
      isExactMatch,
      ...rest
    } = this.props;
    const paginatedIndices = indices.slice(this.pager.firstItemIndex, this.pager.lastItemIndex + 1);
    const rows = paginatedIndices.map((index, key) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: key
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, this.highlightIndexName(index.name, query)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, index.tags.map(tag => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: `index_${key}_tag_${tag.key}`,
          color: tag.color
        }, tag.name);
      })));
    });
    return /*#__PURE__*/_react.default.createElement("div", rest, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
      responsive: false,
      tableLayout: "auto"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, rows)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderPagination());
  }
}
exports.IndicesList = IndicesList;