"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _data_view_editor_service = require("../../data_view_editor_service");
var _shared_imports = require("../../shared_imports");
var _form_schema = require("../form_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const requireTimestampOptionValidator = options => ({
  validator: async ({
    value
  }) => {
    const isValueRequired = !!options.length;
    if (isValueRequired && !value) {
      return {
        message: _i18n.i18n.translate('indexPatternEditor.requireTimestampOption.ValidationErrorMessage', {
          defaultMessage: 'Select a timestamp field.'
        })
      };
    }
  }
});
const getTimestampConfig = options => {
  const timestampFieldConfig = _form_schema.schema.timestampField;
  const validations = [...timestampFieldConfig.validations,
  // note this is responsible for triggering the state update for the selected source list.
  requireTimestampOptionValidator(options)];
  return {
    ...timestampFieldConfig,
    validations
  };
};
const noTimestampOptionText = _i18n.i18n.translate('indexPatternEditor.editor.form.noTimeFieldsLabel', {
  defaultMessage: 'No matching data stream, index, or index alias has a timestamp field.'
});
const timestampFieldHelp = _i18n.i18n.translate('indexPatternEditor.editor.form.timeFieldHelp', {
  defaultMessage: 'Select a timestamp field for use with the global time filter.'
});
const TimestampField = ({
  options$,
  isLoadingOptions$,
  matchedIndices$
}) => {
  const options = (0, _useObservable.default)(options$, []);
  const isLoadingOptions = (0, _useObservable.default)(isLoadingOptions$, false);
  const hasMatchedIndices = !!(0, _useObservable.default)(matchedIndices$, _data_view_editor_service.matchedIndiciesDefault).exactMatchedIndices.length;
  const optionsAsComboBoxOptions = options.map(({
    display,
    fieldName
  }) => ({
    label: display,
    value: fieldName
  }));
  const timestampConfig = (0, _react.useMemo)(() => getTimestampConfig(options), [options]);
  const selectTimestampHelp = options.length ? timestampFieldHelp : '';
  const timestampNoFieldsHelp = options.length === 0 && !isLoadingOptions && hasMatchedIndices ? noTimestampOptionText : '';
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: timestampConfig,
    path: "timestampField"
  }, field => {
    const {
      label,
      value,
      setValue
    } = field;
    if (value === undefined) {
      return null;
    }
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    const isDisabled = !optionsAsComboBoxOptions.length || isLoadingOptions;
    // if the value isn't in the list then don't use it.
    const valueInList = !!optionsAsComboBoxOptions.find(option => option.value === value.value);
    if ((!value || !valueInList) && !isDisabled) {
      const val = optionsAsComboBoxOptions.filter(el => el.value === '@timestamp');
      if (val.length) {
        setValue(val[0]);
      }
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      error: isDisabled ? null : errorMessage,
      isInvalid: !isDisabled && isInvalid,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('indexPatternEditor.editor.form.runtimeType.placeholderLabel', {
        defaultMessage: 'Select a timestamp field'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: optionsAsComboBoxOptions,
      selectedOptions: value && valueInList ? [value] : undefined,
      onChange: newValue => {
        if (newValue.length === 0) {
          // Don't allow clearing the type. One must always be selected
          return;
        }
        //
        setValue(newValue[0]);
      },
      isClearable: false,
      isDisabled: isDisabled,
      "data-test-subj": "timestampField",
      "aria-label": _i18n.i18n.translate('indexPatternEditor.editor.form.timestampSelectAriaLabel', {
        defaultMessage: 'Timestamp field'
      }),
      isLoading: isLoadingOptions,
      fullWidth: true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, null, timestampNoFieldsHelp || selectTimestampHelp || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0")))));
  });
};
exports.TimestampField = TimestampField;