"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelContext = exports.Panel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _flyout_panels = require("./flyout_panels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const flyoutPanelContext = /*#__PURE__*/(0, _react.createContext)({
  registerFooter: () => {},
  registerContent: () => {}
});
const Panel = ({
  children,
  width,
  className = '',
  backgroundColor,
  border,
  ...rest
}) => {
  const [config, setConfig] = (0, _react.useState)({
    hasContent: false,
    hasFooter: false
  });
  const classes = (0, _classnames.default)('fieldEditor__flyoutPanel', className, {
    'fieldEditor__flyoutPanel--pageBackground': backgroundColor === 'euiPageBackground',
    'fieldEditor__flyoutPanel--emptyShade': backgroundColor === 'euiEmptyShade',
    'fieldEditor__flyoutPanel--leftBorder': border === 'left',
    'fieldEditor__flyoutPanel--rightBorder': border === 'right',
    'fieldEditor__flyoutPanel--withContent': config.hasContent
  });
  const {
    addPanel
  } = (0, _flyout_panels.useFlyoutPanelsContext)();
  const registerContent = (0, _react.useCallback)(() => {
    setConfig(prev => {
      return {
        ...prev,
        hasContent: true
      };
    });
  }, []);
  const registerFooter = (0, _react.useCallback)(() => {
    setConfig(prev => {
      if (!prev.hasContent) {
        throw new Error('You need to add a <FlyoutPanels.Content /> when you add a <FlyoutPanels.Footer />');
      }
      return {
        ...prev,
        hasFooter: true
      };
    });
  }, []);
  (0, _react.useLayoutEffect)(() => {
    const removePanel = addPanel({
      width
    });
    return removePanel;
  }, [width, addPanel]);
  const styles = {};
  if (width) {
    styles.flexBasis = `${width}%`;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: styles
  }, /*#__PURE__*/_react.default.createElement(flyoutPanelContext.Provider, {
    value: {
      registerContent,
      registerFooter
    }
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children)));
};
exports.Panel = Panel;
const useFlyoutPanelContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelContext);
  if (ctx === undefined) {
    throw new Error('useFlyoutPanel() must be used within a <flyoutPanelContext.Provider />');
  }
  return ctx;
};
exports.useFlyoutPanelContext = useFlyoutPanelContext;