"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedParamsContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _advanced_params_section = require("./advanced_params_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const allowHiddenAriaLabel = _i18n.i18n.translate('indexPatternEditor.form.allowHiddenAriaLabel', {
  defaultMessage: 'Allow hidden and system indices'
});
const customIndexPatternIdLabel = _i18n.i18n.translate('indexPatternEditor.form.customIndexPatternIdLabel', {
  defaultMessage: 'Custom data view ID'
});
const AdvancedParamsContent = ({
  disableAllowHidden,
  disableId,
  onAllowHiddenChange
}) => /*#__PURE__*/_react.default.createElement(_advanced_params_section.AdvancedParamsSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: 'allowHidden',
  component: _shared_imports.ToggleField,
  "data-test-subj": "allowHiddenField",
  componentProps: {
    euiFieldProps: {
      'aria-label': allowHiddenAriaLabel,
      disabled: disableAllowHidden
    }
  },
  onChange: onAllowHiddenChange
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: 'id',
  component: _shared_imports.TextField,
  "data-test-subj": "savedObjectIdField",
  componentProps: {
    euiFieldProps: {
      'aria-label': customIndexPatternIdLabel,
      disabled: disableId
    }
  }
}))));
exports.AdvancedParamsContent = AdvancedParamsContent;