"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchProvider = fetchProvider;
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function fetchProvider(getIndexForType, logger) {
  return async ({
    esClient
  }) => {
    try {
      const searchSessionIndex = await getIndexForType(_common.SEARCH_SESSION_TYPE);
      const esResponse = await esClient.search({
        index: searchSessionIndex,
        body: {
          size: 0,
          aggs: {
            persisted: {
              terms: {
                field: `${_common.SEARCH_SESSION_TYPE}.persisted`
              }
            }
          }
        }
      });
      const aggs = esResponse.aggregations;
      const buckets = aggs.persisted.buckets;
      if (!buckets.length) {
        return {
          transientCount: 0,
          persistedCount: 0,
          totalCount: 0
        };
      }
      const {
        transientCount = 0,
        persistedCount = 0
      } = buckets.reduce((usage, bucket) => {
        const key = bucket.key_as_string === 'false' ? 'transientCount' : 'persistedCount';
        return {
          ...usage,
          [key]: bucket.doc_count
        };
      }, {});
      const totalCount = transientCount + persistedCount;
      logger.debug(`fetchProvider | ${persistedCount} persisted | ${transientCount} transient`);
      return {
        transientCount,
        persistedCount,
        totalCount
      };
    } catch (e) {
      logger.warn(`fetchProvider | error | ${e.message}`);
      return {
        transientCount: 0,
        persistedCount: 0,
        totalCount: 0
      };
    }
  };
}