"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEMA_QUERY_V8_8_0 = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// As per `SavedQueryAttributes`
const SCHEMA_QUERY_V8_8_0 = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string({
    defaultValue: ''
  }),
  query: _configSchema.schema.object({
    language: _configSchema.schema.string(),
    query: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({}, {
      unknowns: 'allow'
    })])
  }),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))),
  timefilter: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.string(),
    to: _configSchema.schema.string(),
    refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
      value: _configSchema.schema.number(),
      pause: _configSchema.schema.boolean()
    }))
  }))
});
exports.SCHEMA_QUERY_V8_8_0 = SCHEMA_QUERY_V8_8_0;