"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureTable = ShardFailureTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("@elastic/eui/lib/services");
var _i18n = require("@kbn/i18n");
var _shard_failure_description = require("./shard_failure_description");
var _shard_failure_description_header = require("./shard_failure_description_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

// @ts-ignore

function ShardFailureTable({
  failures
}) {
  const itemList = failures.map((failure, idx) => ({
    ...{
      id: String(idx)
    },
    ...failure
  }));
  const initalMap = {};
  const [expandMap, setExpandMap] = (0, _react.useState)(initalMap);
  const columns = [{
    align: _services.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => {
      const failureSummeryText = (0, _shard_failure_description_header.getFailureSummaryText)(item);
      const collapseLabel = _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableRowCollapse', {
        defaultMessage: 'Collapse {rowDescription}',
        description: 'Collapse a row of a table with failures',
        values: {
          rowDescription: failureSummeryText
        }
      });
      const expandLabel = _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableRowExpand', {
        defaultMessage: 'Expand {rowDescription}',
        description: 'Expand a row of a table with failures',
        values: {
          rowDescription: failureSummeryText
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => {
          // toggle displaying the expanded view of the given list item
          const map = Object.assign({}, expandMap);
          if (map[item.id]) {
            delete map[item.id];
          } else {
            map[item.id] = /*#__PURE__*/_react.default.createElement(_shard_failure_description.ShardFailureDescription, item);
          }
          setExpandMap(map);
        },
        "aria-label": expandMap[item.id] ? collapseLabel : expandLabel,
        iconType: expandMap[item.id] ? 'arrowUp' : 'arrowDown'
      });
    }
  }, {
    field: 'shard',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColShard', {
      defaultMessage: 'Shard'
    }),
    sortable: true,
    truncateText: true,
    width: '80px'
  }, {
    field: 'index',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColIndex', {
      defaultMessage: 'Index'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'node',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColNode', {
      defaultMessage: 'Node'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'reason.type',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColReason', {
      defaultMessage: 'Reason'
    }),
    truncateText: true
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    items: itemList,
    columns: columns,
    pagination: true,
    sorting: {
      sort: {
        field: 'index',
        direction: 'desc'
      }
    },
    itemIdToExpandedRowMap: expandMap
  });
}