"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ShardFailureOpenModalButton;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
var _shard_failure_modal = require("./shard_failure_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
function ShardFailureOpenModalButton({
  getRequestMeta,
  theme,
  title,
  size = 's',
  color = 'warning',
  isButtonEmpty = false
}) {
  const onClick = (0, _react.useCallback)(() => {
    const {
      request,
      response
    } = getRequestMeta();
    const modal = (0, _services.getOverlays)().openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_shard_failure_modal.ShardFailureModal, {
      request: request,
      response: response,
      title: title,
      onClose: () => modal.close()
    }), {
      theme$: theme.theme$
    }), {
      className: 'shardFailureModal'
    });
  }, [getRequestMeta, theme.theme$, title]);
  const Component = isButtonEmpty ? _eui.EuiLink : _eui.EuiButton;
  return /*#__PURE__*/_react.default.createElement(Component, {
    color: color,
    size: size,
    onClick: onClick,
    "data-test-subj": "openShardFailureModalBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.search.searchSource.fetch.shardsFailedModal.showDetails",
    defaultMessage: "Show details",
    description: "Open the modal to show details"
  }));
}
module.exports = exports.default;