"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureModal = ShardFailureModal;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_table = require("./shard_failure_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ShardFailureModal({
  request,
  response,
  title,
  onClose
}) {
  if (!response || !response._shards || !Array.isArray(response._shards.failures) || !request) {
    // this should never ever happen, but just in case
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Sorry, there was an error",
      color: "danger",
      iconType: "warning"
    }, "The ShardFailureModal component received invalid properties");
  }
  const failures = response._shards.failures;
  const requestJSON = JSON.stringify(request, null, 2);
  const responseJSON = JSON.stringify(response, null, 2);
  const tabs = [{
    id: 'table',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderShardFailures', {
      defaultMessage: 'Shard failures',
      description: 'Name of the tab displaying shard failures'
    }),
    content: /*#__PURE__*/_react.default.createElement(_shard_failure_table.ShardFailureTable, {
      failures: failures
    }),
    ['data-test-subj']: 'shardFailuresModalShardButton'
  }, {
    id: 'json-request',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderRequest', {
      defaultMessage: 'Request',
      description: 'Name of the tab displaying the JSON request'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      "data-test-subj": "shardsFailedModalRequestBlock"
    }, requestJSON),
    ['data-test-subj']: 'shardFailuresModalRequestButton'
  }, {
    id: 'json-response',
    name: _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tabHeaderResponse', {
      defaultMessage: 'Response',
      description: 'Name of the tab displaying the JSON response'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      "data-test-subj": "shardsFailedModalResponseBlock"
    }, responseJSON),
    ['data-test-subj']: 'shardFailuresModalResponseButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "shardFailureModalTitle"
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: responseJSON
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: copy
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.search.searchSource.fetch.shardsFailedModal.copyToClipboard",
    defaultMessage: "Copy response to clipboard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onClose(),
    fill: true,
    "data-test-subj": "closeShardFailureModal"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.search.searchSource.fetch.shardsFailedModal.close",
    defaultMessage: "Close",
    description: "Closing the Modal"
  }))));
}