"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("../../../../../common");
var _components = require("../components");
var _status = require("../components/status");
var _date_string = require("./date_string");
var _get_expiration_status = require("./get_expiration_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Helper function: translate an app string to EuiIcon-friendly string
const appToIcon = app => {
  if (app === 'dashboards') {
    return 'dashboard';
  }
  if (app === 'ml') {
    return 'machineLearning';
  }
  return app;
};

// Helper function: translate an app id to user friendly string
const appToTooltip = appId => {
  if (appId === 'ml') {
    return _i18n.i18n.translate('data.mgmt.searchSessions.table.mlAppName', {
      defaultMessage: 'Machine Learning'
    });
  }
};
function isSessionRestorable(status) {
  return status === _common.SearchSessionStatus.IN_PROGRESS || status === _common.SearchSessionStatus.COMPLETE;
}
const getColumns = (core, api, config, timezone, onActionComplete, kibanaVersion, searchUsageCollector) => {
  // Use a literal array of table column definitions to detail a UISession object
  return [
  // App
  {
    field: 'appId',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerType', {
      defaultMessage: 'App'
    }),
    sortable: true,
    render: (appId, {
      id
    }) => {
      var _appToTooltip;
      const app = `${appToIcon(appId)}`;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: (_appToTooltip = appToTooltip(appId)) !== null && _appToTooltip !== void 0 ? _appToTooltip : (0, _lodash.capitalize)(app)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "data-test-subj": "sessionManagementAppIcon",
        "data-test-app-id": app,
        type: `${app}App`
      }));
    }
  },
  // Name, links to app and displays the search session data
  {
    field: 'name',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerName', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    width: '20%',
    render: (name, {
      restoreUrl,
      reloadUrl,
      status,
      version
    }) => {
      const isRestorable = isSessionRestorable(status);
      const href = isRestorable ? restoreUrl : reloadUrl;
      const trackAction = isRestorable ? searchUsageCollector.trackSessionViewRestored : searchUsageCollector.trackSessionReloaded;
      const notRestorableWarning = isRestorable ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "warning",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "data.mgmt.searchSessions.table.notRestorableWarning",
          defaultMessage: "The search session will be executed again. You can then save it for future use."
        })
      }));

      // show version warning only if:
      // 1. the session was created in a different version of Kibana
      // AND
      // 2. if still can restore this session: it has IN_PROGRESS or COMPLETE status.
      const versionIncompatibleWarning = isRestorable && version !== kibanaVersion ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "warning",
        iconProps: {
          'data-test-subj': 'versionIncompatibleWarningTestSubj'
        },
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "data.mgmt.searchSessions.table.versionIncompatibleWarning",
          defaultMessage: "This search session was created in a Kibana instance running a different version. It may not restore correctly."
        })
      })) : null;
      return /*#__PURE__*/_react.default.createElement(_public.RedirectAppLinks, {
        application: core.application
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: href,
        onClick: () => trackAction === null || trackAction === void 0 ? void 0 : trackAction(),
        "data-test-subj": "sessionManagementNameCol"
      }, /*#__PURE__*/_react.default.createElement(_components.TableText, null, name, notRestorableWarning, versionIncompatibleWarning)));
    }
  },
  // # Searches
  {
    field: 'numSearches',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.numSearches', {
      defaultMessage: '# Searches'
    }),
    sortable: true,
    render: (numSearches, session) => /*#__PURE__*/_react.default.createElement(_components.TableText, {
      color: "subdued",
      "data-test-subj": "sessionManagementNumSearchesCol"
    }, numSearches)
  },
  // Session status
  {
    field: 'status',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerStatus', {
      defaultMessage: 'Status'
    }),
    sortable: true,
    render: (statusType, session) => /*#__PURE__*/_react.default.createElement(_status.StatusIndicator, {
      session: session,
      timezone: timezone
    })
  },
  // Started date
  {
    field: 'created',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerStarted', {
      defaultMessage: 'Created'
    }),
    sortable: true,
    render: (created, {
      id
    }) => {
      try {
        const startedOn = (0, _date_string.dateString)(created, timezone);
        return /*#__PURE__*/_react.default.createElement(_components.TableText, {
          color: "subdued",
          "data-test-subj": "sessionManagementCreatedCol"
        }, startedOn);
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        return /*#__PURE__*/_react.default.createElement(_components.TableText, null, created);
      }
    }
  },
  // Expiration date
  {
    field: 'expires',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerExpiration', {
      defaultMessage: 'Expiration'
    }),
    sortable: true,
    render: (expires, {
      id,
      status
    }) => {
      if (expires && status !== _common.SearchSessionStatus.EXPIRED && status !== _common.SearchSessionStatus.CANCELLED && status !== _common.SearchSessionStatus.ERROR) {
        try {
          const expiresOn = (0, _date_string.dateString)(expires, timezone);

          // return
          return /*#__PURE__*/_react.default.createElement(_components.TableText, {
            color: "subdued",
            "data-test-subj": "sessionManagementExpiresCol"
          }, expiresOn);
        } catch (err) {
          // eslint-disable-next-line no-console
          console.error(err);
          return /*#__PURE__*/_react.default.createElement(_components.TableText, null, expires);
        }
      }
      return /*#__PURE__*/_react.default.createElement(_components.TableText, {
        color: "subdued",
        "data-test-subj": "sessionManagementExpiresCol"
      }, "--");
    }
  },
  // Highlight Badge, if completed session expires soon
  {
    field: 'status',
    name: '',
    sortable: false,
    render: (status, {
      expires
    }) => {
      const expirationStatus = (0, _get_expiration_status.getExpirationStatus)(config, expires);
      if (expirationStatus) {
        const {
          toolTipContent,
          statusContent
        } = expirationStatus;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: toolTipContent
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning",
          "data-test-subj": "sessionManagementStatusCol"
        }, statusContent));
      }
      return /*#__PURE__*/_react.default.createElement(_components.TableText, null);
    }
  },
  // Action(s) in-line in the row, additional action(s) in the popover, no column header
  {
    field: 'actions',
    name: '',
    sortable: false,
    render: (actions, session) => {
      if (actions && actions.length) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "l",
          justifyContent: "flexEnd",
          alignItems: "flexEnd"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          "data-test-subj": "sessionManagementActionsCol"
        }, /*#__PURE__*/_react.default.createElement(_components.PopoverActionsMenu, {
          api: api,
          key: `popkey-${session.id}`,
          session: session,
          core: core,
          onActionComplete: onActionComplete
        })));
      }
    }
  }];
};
exports.getColumns = getColumns;