"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * CRUD Search Session SO
 */
class SessionsClient {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = deps.http;
  }
  get(sessionId) {
    return this.http.get(`/internal/session/${encodeURIComponent(sessionId)}`);
  }
  create({
    name,
    appId,
    locatorId,
    initialState,
    restoreState,
    sessionId
  }) {
    return this.http.post(`/internal/session`, {
      body: JSON.stringify({
        name,
        appId,
        locatorId,
        initialState,
        restoreState,
        sessionId
      })
    });
  }
  find(options) {
    return this.http.post(`/internal/session/_find`, {
      body: JSON.stringify(options)
    });
  }
  update(sessionId, attributes) {
    return this.http.put(`/internal/session/${encodeURIComponent(sessionId)}`, {
      body: JSON.stringify(attributes)
    });
  }
  rename(sessionId, newName) {
    return this.update(sessionId, {
      name: newName
    });
  }
  extend(sessionId, expires) {
    return this.http.post(`/internal/session/${encodeURIComponent(sessionId)}/_extend`, {
      body: JSON.stringify({
        expires
      })
    });
  }
  delete(sessionId) {
    return this.http.delete(`/internal/session/${encodeURIComponent(sessionId)}`);
  }
}
exports.SessionsClient = SessionsClient;