"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRequestHash = createRequestHash;
exports.getSearchErrorOverrideDisplay = getSearchErrorOverrideDisplay;
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _cryptoBrowser = require("@kbn/crypto-browser");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/bfetch-plugin/public");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function createRequestHash(keys) {
  return new _cryptoBrowser.Sha256().update((0, _jsonStableStringify.default)(keys), 'utf8').digest('hex');
}
function getSearchErrorOverrideDisplay({
  error,
  application
}) {
  if (error instanceof _errors.EsError) {
    return {
      title: _i18n.i18n.translate('data.search.esErrorTitle', {
        defaultMessage: 'Cannot retrieve search results'
      }),
      body: error.getErrorMessage(application)
    };
  }
  if (error.constructor.name === 'HttpFetchError' || error instanceof _public.BfetchRequestError) {
    const defaultMsg = _i18n.i18n.translate('data.errors.fetchError', {
      defaultMessage: 'Check your network connection and try again.'
    });
    return {
      title: _i18n.i18n.translate('data.search.httpErrorTitle', {
        defaultMessage: 'Unable to connect to the Kibana server'
      }),
      body: error.message || defaultMsg
    };
  }
}