"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PainlessError = void 0;
exports.isPainlessError = isPainlessError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("./types");
var _es_error = require("./es_error");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PainlessError extends _es_error.EsError {
  constructor(err, indexPattern) {
    super(err);
    (0, _defineProperty2.default)(this, "painlessStack", void 0);
    (0, _defineProperty2.default)(this, "indexPattern", void 0);
    this.indexPattern = indexPattern;
  }
  getErrorMessage(application) {
    var _rootCause$script_sta, _rootCause$script_sta2, _rootCause$script_sta3, _rootCause$caused_by, _this$indexPattern, _this$indexPattern2;
    function onClick(indexPatternId) {
      application.navigateToApp('management', {
        path: `/kibana/indexPatterns${indexPatternId ? `/patterns/${indexPatternId}` : ''}`
      });
    }
    const rootCause = (0, _utils.getRootCause)(this.err);
    const scriptFromStackTrace = rootCause !== null && rootCause !== void 0 && rootCause.script_stack ? rootCause === null || rootCause === void 0 ? void 0 : (_rootCause$script_sta = rootCause.script_stack) === null || _rootCause$script_sta === void 0 ? void 0 : _rootCause$script_sta.slice(-2).join('\n') : undefined;
    // if the error has been properly processed it will highlight where it occurred.
    const hasScript = (rootCause === null || rootCause === void 0 ? void 0 : (_rootCause$script_sta2 = rootCause.script_stack) === null || _rootCause$script_sta2 === void 0 ? void 0 : (_rootCause$script_sta3 = _rootCause$script_sta2.slice(-1)[0]) === null || _rootCause$script_sta3 === void 0 ? void 0 : _rootCause$script_sta3.indexOf('HERE')) || -1 >= 0;
    const humanReadableError = rootCause === null || rootCause === void 0 ? void 0 : (_rootCause$caused_by = rootCause.caused_by) === null || _rootCause$caused_by === void 0 ? void 0 : _rootCause$caused_by.reason;
    // fallback, show ES stacktrace
    const painlessStack = rootCause !== null && rootCause !== void 0 && rootCause.script_stack ? rootCause === null || rootCause === void 0 ? void 0 : rootCause.script_stack.join('\n') : undefined;
    const indexPatternId = this === null || this === void 0 ? void 0 : (_this$indexPattern = this.indexPattern) === null || _this$indexPattern === void 0 ? void 0 : _this$indexPattern.id;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "painlessScript"
    }, _i18n.i18n.translate('data.painlessError.painlessScriptedFieldErrorMessage', {
      defaultMessage: 'Error executing runtime field or scripted field on index pattern {indexPatternName}',
      values: {
        indexPatternName: this === null || this === void 0 ? void 0 : (_this$indexPattern2 = this.indexPattern) === null || _this$indexPattern2 === void 0 ? void 0 : _this$indexPattern2.title
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), scriptFromStackTrace || painlessStack ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      "data-test-subj": "painlessStackTrace",
      isCopyable: true,
      paddingSize: "s"
    }, hasScript ? scriptFromStackTrace : painlessStack) : null, humanReadableError ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "painlessHumanReadableError"
    }, humanReadableError) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: () => onClick(indexPatternId),
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.painlessError.buttonTxt",
      defaultMessage: "Edit script"
    }))));
  }
}
exports.PainlessError = PainlessError;
function isPainlessError(err) {
  if (!(0, _types.isEsError)(err)) return false;
  const rootCause = (0, _utils.getRootCause)(err);
  if (!rootCause) return false;
  const {
    lang
  } = rootCause;
  return lang === 'painless';
}