"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSavedQueryService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createSavedQueryService = http => {
  const createQuery = async (attributes, {
    overwrite = false
  } = {}) => {
    const savedQuery = await http.post('/api/saved_query/_create', {
      body: JSON.stringify(attributes)
    });
    return savedQuery;
  };
  const updateQuery = async (id, attributes) => {
    const savedQuery = await http.put(`/api/saved_query/${id}`, {
      body: JSON.stringify(attributes)
    });
    return savedQuery;
  };

  // we have to tell the saved objects client how many to fetch, otherwise it defaults to fetching 20 per page
  const getAllSavedQueries = async () => {
    const {
      savedQueries
    } = await http.post('/api/saved_query/_all');
    return savedQueries;
  };

  // findSavedQueries will do a 'match_all' if no search string is passed in
  const findSavedQueries = async (search = '', perPage = 50, page = 1) => {
    const {
      total,
      savedQueries: queries
    } = await http.post('/api/saved_query/_find', {
      body: JSON.stringify({
        page,
        perPage,
        search
      })
    });
    return {
      total,
      queries
    };
  };
  const getSavedQuery = id => {
    return http.get(`/api/saved_query/${id}`);
  };
  const deleteSavedQuery = id => {
    return http.delete(`/api/saved_query/${id}`);
  };
  const getSavedQueryCount = async () => {
    return http.get('/api/saved_query/_count');
  };
  return {
    createQuery,
    updateQuery,
    getAllSavedQueries,
    findSavedQueries,
    getSavedQuery,
    deleteSavedQuery,
    getSavedQueryCount
  };
};
exports.createSavedQueryService = createSavedQueryService;