"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapCombined = void 0;
var _esQuery = require("@kbn/es-query");
var _map_filter = require("../map_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mapCombined = filter => {
  if (!(0, _esQuery.isCombinedFilter)(filter)) {
    throw filter;
  }
  const {
    type,
    key,
    params
  } = filter.meta;
  return {
    type,
    key,
    params: params.map(_map_filter.mapFilter)
  };
};
exports.mapCombined = mapCombined;