"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFiltersFromRangeSelectAction = createFiltersFromRangeSelectAction;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _esQuery = require("@kbn/es-query");
var _services = require("../../services");
var _query = require("../../query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function createFiltersFromRangeSelectAction(event) {
  const column = event.table.columns[event.column];
  if (!column || !column.meta) {
    return [];
  }
  const {
    indexPatternId,
    ...aggConfigs
  } = column.meta.sourceParams;
  const indexPattern = await (0, _services.getIndexPatterns)().get(indexPatternId);
  const aggConfigsInstance = (0, _services.getSearchService)().aggs.createAggConfigs(indexPattern, [aggConfigs]);
  const aggConfig = aggConfigsInstance.aggs[0];
  const field = aggConfig.params.field;
  if (!field || event.range.length <= 1) {
    return [];
  }
  const min = event.range[0];
  const max = (0, _lodash.last)(event.range);
  if (min === max) {
    return [];
  }
  const isDate = field.type === 'date';
  const range = {
    gte: isDate ? (0, _moment.default)(min).toISOString() : min,
    lt: isDate ? (0, _moment.default)(max).toISOString() : max
  };
  if (isDate) {
    range.format = 'strict_date_optional_time';
  }
  return (0, _query.mapAndFlattenFilters)([(0, _esQuery.buildRangeFilter)(field, range, indexPattern)]);
}