"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectsTaggingServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const savedObjectsTaggingServiceFactory = ({
  startPlugins
}) => {
  const {
    savedObjectsTaggingOss
  } = startPlugins;
  if (!savedObjectsTaggingOss) return {
    hasApi: false
  };
  const {
    getTaggingApi
  } = savedObjectsTaggingOss;
  const taggingApi = getTaggingApi();
  if (!taggingApi) return {
    hasApi: false
  };
  const {
    ui: {
      components,
      parseSearchQuery,
      hasTagDecoration,
      getSearchBarFilter,
      updateTagsReferences,
      getTagIdsFromReferences,
      getTableColumnDefinition,
      getTagList
    }
  } = taggingApi;
  return {
    hasApi: true,
    api: taggingApi,
    components,
    hasTagDecoration,
    parseSearchQuery,
    getSearchBarFilter,
    updateTagsReferences,
    getTagIdsFromReferences,
    getTableColumnDefinition,
    getTagList
  };
};
exports.savedObjectsTaggingServiceFactory = savedObjectsTaggingServiceFactory;