"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registry = exports.providers = void 0;
var _public = require("@kbn/presentation-util-plugin/public");
var _analytics = require("./analytics/analytics.stub");
var _application = require("./application/application.stub");
var _chrome = require("./chrome/chrome.stub");
var _core_context = require("./core_context/core_context.stub");
var _dashboard_capabilities = require("./dashboard_capabilities/dashboard_capabilities.stub");
var _dashboard_session_storage = require("./dashboard_session_storage/dashboard_session_storage.stub");
var _data = require("./data/data.stub");
var _data_view_editor = require("./data_view_editor/data_view_editor.stub");
var _documentation_links = require("./documentation_links/documentation_links.stub");
var _embeddable = require("./embeddable/embeddable.stub");
var _http = require("./http/http.stub");
var _initializer_context = require("./initializer_context/initializer_context.stub");
var _navigation = require("./navigation/navigation.stub");
var _notifications = require("./notifications/notifications.stub");
var _overlays = require("./overlays/overlays.stub");
var _saved_objects_tagging = require("./saved_objects_tagging/saved_objects_tagging.stub");
var _screenshot_mode = require("./screenshot_mode/screenshot_mode.stub");
var _settings = require("./settings/settings.stub");
var _share = require("./share/share.stub");
var _usage_collection = require("./usage_collection/usage_collection.stub");
var _spaces = require("./spaces/spaces.stub");
var _url_fowarding = require("./url_forwarding/url_fowarding.stub");
var _visualizations = require("./visualizations/visualizations.stub");
var _dashboard_saved_object = require("./dashboard_saved_object/dashboard_saved_object.stub");
var _custom_branding = require("./custom_branding/custom_branding.stub");
var _saved_objects_management_service = require("./saved_objects_management/saved_objects_management_service.stub");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = {
  dashboardSavedObject: new _public.PluginServiceProvider(_dashboard_saved_object.dashboardSavedObjectServiceFactory),
  analytics: new _public.PluginServiceProvider(_analytics.analyticsServiceFactory),
  application: new _public.PluginServiceProvider(_application.applicationServiceFactory),
  chrome: new _public.PluginServiceProvider(_chrome.chromeServiceFactory),
  coreContext: new _public.PluginServiceProvider(_core_context.coreContextServiceFactory),
  dashboardCapabilities: new _public.PluginServiceProvider(_dashboard_capabilities.dashboardCapabilitiesServiceFactory),
  dashboardSessionStorage: new _public.PluginServiceProvider(_dashboard_session_storage.dashboardSessionStorageServiceFactory),
  data: new _public.PluginServiceProvider(_data.dataServiceFactory),
  dataViewEditor: new _public.PluginServiceProvider(_data_view_editor.dataViewEditorServiceFactory),
  documentationLinks: new _public.PluginServiceProvider(_documentation_links.documentationLinksServiceFactory),
  embeddable: new _public.PluginServiceProvider(_embeddable.embeddableServiceFactory),
  http: new _public.PluginServiceProvider(_http.httpServiceFactory),
  initializerContext: new _public.PluginServiceProvider(_initializer_context.initializerContextServiceFactory),
  navigation: new _public.PluginServiceProvider(_navigation.navigationServiceFactory),
  notifications: new _public.PluginServiceProvider(_notifications.notificationsServiceFactory),
  overlays: new _public.PluginServiceProvider(_overlays.overlaysServiceFactory),
  savedObjectsTagging: new _public.PluginServiceProvider(_saved_objects_tagging.savedObjectsTaggingServiceFactory),
  screenshotMode: new _public.PluginServiceProvider(_screenshot_mode.screenshotModeServiceFactory),
  settings: new _public.PluginServiceProvider(_settings.settingsServiceFactory),
  share: new _public.PluginServiceProvider(_share.shareServiceFactory),
  spaces: new _public.PluginServiceProvider(_spaces.spacesServiceFactory),
  urlForwarding: new _public.PluginServiceProvider(_url_fowarding.urlForwardingServiceFactory),
  usageCollection: new _public.PluginServiceProvider(_usage_collection.usageCollectionServiceFactory),
  visualizations: new _public.PluginServiceProvider(_visualizations.visualizationsServiceFactory),
  customBranding: new _public.PluginServiceProvider(_custom_branding.customBrandingServiceFactory),
  savedObjectsManagement: new _public.PluginServiceProvider(_saved_objects_management_service.savedObjectsManagementServiceFactory)
};
exports.providers = providers;
const registry = new _public.PluginServiceRegistry(providers);
exports.registry = registry;