"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registry = exports.pluginServices = void 0;
var _public = require("@kbn/presentation-util-plugin/public");
var _application_service = require("./application/application_service");
var _chrome_service = require("./chrome/chrome_service");
var _core_context_service = require("./core_context/core_context_service");
var _dashboard_capabilities_service = require("./dashboard_capabilities/dashboard_capabilities_service");
var _dashboard_session_storage_service = require("./dashboard_session_storage/dashboard_session_storage_service");
var _data_service = require("./data/data_service");
var _data_view_editor_service = require("./data_view_editor/data_view_editor_service");
var _documentation_links_service = require("./documentation_links/documentation_links_service");
var _embeddable_service = require("./embeddable/embeddable_service");
var _http_service = require("./http/http_service");
var _initializer_context_service = require("./initializer_context/initializer_context_service");
var _navigation_service = require("./navigation/navigation_service");
var _notifications_service = require("./notifications/notifications_service");
var _overlays_service = require("./overlays/overlays_service");
var _screenshot_mode_service = require("./screenshot_mode/screenshot_mode_service");
var _saved_objects_tagging_service = require("./saved_objects_tagging/saved_objects_tagging_service");
var _settings_service = require("./settings/settings_service");
var _share_services = require("./share/share_services");
var _spaces_service = require("./spaces/spaces_service");
var _url_forwarding_service = require("./url_forwarding/url_forwarding_service");
var _visualizations_service = require("./visualizations/visualizations_service");
var _usage_collection_service = require("./usage_collection/usage_collection_service");
var _analytics_service = require("./analytics/analytics_service");
var _dashboard_saved_object_service = require("./dashboard_saved_object/dashboard_saved_object_service");
var _custom_branding_service = require("./custom_branding/custom_branding_service");
var _saved_objects_management_service = require("./saved_objects_management/saved_objects_management_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = {
  dashboardSavedObject: new _public.PluginServiceProvider(_dashboard_saved_object_service.dashboardSavedObjectServiceFactory, ['dashboardSessionStorage', 'savedObjectsTagging', 'initializerContext', 'screenshotMode', 'notifications', 'embeddable', 'spaces', 'data']),
  dashboardSessionStorage: new _public.PluginServiceProvider(_dashboard_session_storage_service.dashboardSessionStorageServiceFactory, ['notifications', 'spaces']),
  analytics: new _public.PluginServiceProvider(_analytics_service.analyticsServiceFactory),
  application: new _public.PluginServiceProvider(_application_service.applicationServiceFactory),
  chrome: new _public.PluginServiceProvider(_chrome_service.chromeServiceFactory),
  coreContext: new _public.PluginServiceProvider(_core_context_service.coreContextServiceFactory),
  dashboardCapabilities: new _public.PluginServiceProvider(_dashboard_capabilities_service.dashboardCapabilitiesServiceFactory),
  data: new _public.PluginServiceProvider(_data_service.dataServiceFactory),
  dataViewEditor: new _public.PluginServiceProvider(_data_view_editor_service.dataViewEditorServiceFactory),
  documentationLinks: new _public.PluginServiceProvider(_documentation_links_service.documentationLinksServiceFactory),
  embeddable: new _public.PluginServiceProvider(_embeddable_service.embeddableServiceFactory),
  http: new _public.PluginServiceProvider(_http_service.httpServiceFactory),
  initializerContext: new _public.PluginServiceProvider(_initializer_context_service.initializerContextServiceFactory),
  navigation: new _public.PluginServiceProvider(_navigation_service.navigationServiceFactory),
  notifications: new _public.PluginServiceProvider(_notifications_service.notificationsServiceFactory),
  overlays: new _public.PluginServiceProvider(_overlays_service.overlaysServiceFactory),
  savedObjectsTagging: new _public.PluginServiceProvider(_saved_objects_tagging_service.savedObjectsTaggingServiceFactory),
  screenshotMode: new _public.PluginServiceProvider(_screenshot_mode_service.screenshotModeServiceFactory),
  settings: new _public.PluginServiceProvider(_settings_service.settingsServiceFactory),
  share: new _public.PluginServiceProvider(_share_services.shareServiceFactory),
  spaces: new _public.PluginServiceProvider(_spaces_service.spacesServiceFactory),
  urlForwarding: new _public.PluginServiceProvider(_url_forwarding_service.urlForwardingServiceFactory),
  usageCollection: new _public.PluginServiceProvider(_usage_collection_service.usageCollectionServiceFactory),
  visualizations: new _public.PluginServiceProvider(_visualizations_service.visualizationsServiceFactory),
  customBranding: new _public.PluginServiceProvider(_custom_branding_service.customBrandingServiceFactory),
  savedObjectsManagement: new _public.PluginServiceProvider(_saved_objects_management_service.savedObjectsManagementServiceFactory)
};
const pluginServices = new _public.PluginServices();
exports.pluginServices = pluginServices;
const registry = new _public.PluginServiceRegistry(providers);
exports.registry = registry;