"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardSessionStorageServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardSessionStorageServiceFactory = () => {
  return {
    clearState: jest.fn(),
    getState: jest.fn().mockReturnValue(undefined),
    setState: jest.fn(),
    getDashboardIdsWithUnsavedChanges: jest.fn().mockReturnValue(['dashboardUnsavedOne', 'dashboardUnsavedTwo']),
    dashboardHasUnsavedEdits: jest.fn()
  };
};
exports.dashboardSessionStorageServiceFactory = dashboardSessionStorageServiceFactory;