"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findDashboardIdByTitle = findDashboardIdByTitle;
exports.findDashboardSavedObjects = findDashboardSavedObjects;
exports.findDashboardSavedObjectsByIds = findDashboardSavedObjectsByIds;
var _dashboard_constants = require("../../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function findDashboardSavedObjects({
  savedObjectsClient,
  hasReference,
  hasNoReference,
  search,
  size
}) {
  const {
    total,
    savedObjects
  } = await savedObjectsClient.find({
    type: _dashboard_constants.DASHBOARD_SAVED_OBJECT_TYPE,
    search: search ? `${search}*` : undefined,
    searchFields: ['title^3', 'description'],
    defaultSearchOperator: 'AND',
    perPage: size,
    hasReference,
    hasNoReference,
    page: 1
  });
  return {
    total,
    hits: savedObjects
  };
}
async function findDashboardSavedObjectsByIds(savedObjectsClient, ids) {
  const {
    savedObjects
  } = await savedObjectsClient.bulkGet(ids.map(id => ({
    id,
    type: _dashboard_constants.DASHBOARD_SAVED_OBJECT_TYPE
  })));
  return savedObjects.map(savedObjectResult => {
    if (savedObjectResult.error) return {
      status: 'error',
      error: savedObjectResult.error,
      id: savedObjectResult.id
    };
    const {
      attributes,
      id
    } = savedObjectResult;
    return {
      id,
      status: 'success',
      attributes: attributes
    };
  });
}
async function findDashboardIdByTitle(title, savedObjectsClient) {
  const results = await savedObjectsClient.find({
    search: `"${title}"`,
    searchFields: ['title'],
    type: 'dashboard'
  });
  // The search isn't an exact match, lets see if we can find a single exact match to use
  const matchingDashboards = results.savedObjects.filter(dashboard => dashboard.attributes.title.toLowerCase() === title.toLowerCase());
  if (matchingDashboards.length === 1) {
    return {
      id: matchingDashboards[0].id
    };
  }
}