"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardSavedObjectServiceFactory = void 0;
var _check_for_duplicate_dashboard_title = require("./lib/check_for_duplicate_dashboard_title");
var _find_dashboard_saved_objects = require("./lib/find_dashboard_saved_objects");
var _save_dashboard_state_to_saved_object = require("./lib/save_dashboard_state_to_saved_object");
var _load_dashboard_state_from_saved_object = require("./lib/load_dashboard_state_from_saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardSavedObjectServiceFactory = ({
  coreStart
}, requiredServices) => {
  const {
    savedObjects: {
      client: savedObjectsClient
    }
  } = coreStart;
  return {
    loadDashboardStateFromSavedObject: ({
      id
    }) => (0, _load_dashboard_state_from_saved_object.loadDashboardStateFromSavedObject)({
      id,
      savedObjectsClient,
      ...requiredServices
    }),
    saveDashboardStateToSavedObject: ({
      currentState,
      saveOptions,
      lastSavedId
    }) => (0, _save_dashboard_state_to_saved_object.saveDashboardStateToSavedObject)({
      saveOptions,
      lastSavedId,
      currentState,
      savedObjectsClient,
      ...requiredServices
    }),
    findDashboards: {
      findSavedObjects: ({
        hasReference,
        hasNoReference,
        search,
        size
      }) => (0, _find_dashboard_saved_objects.findDashboardSavedObjects)({
        hasReference,
        hasNoReference,
        search,
        size,
        savedObjectsClient
      }),
      findByIds: ids => (0, _find_dashboard_saved_objects.findDashboardSavedObjectsByIds)(savedObjectsClient, ids),
      findByTitle: title => (0, _find_dashboard_saved_objects.findDashboardIdByTitle)(title, savedObjectsClient)
    },
    checkForDuplicateDashboardTitle: props => (0, _check_for_duplicate_dashboard_title.checkForDuplicateDashboardTitle)(props, savedObjectsClient),
    savedObjectsClient
  };
};
exports.dashboardSavedObjectServiceFactory = dashboardSavedObjectServiceFactory;