"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardSavedObjectServiceFactory = void 0;
var _mocks = require("@kbn/core/public/mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardSavedObjectServiceFactory = () => {
  const {
    client: savedObjectsClient
  } = _mocks.savedObjectsServiceMock.createStartContract();
  return {
    loadDashboardStateFromSavedObject: jest.fn().mockImplementation(() => Promise.resolve({
      dashboardInput: {}
    })),
    saveDashboardStateToSavedObject: jest.fn(),
    findDashboards: {
      findSavedObjects: jest.fn().mockImplementation(({
        search,
        size
      }) => {
        const sizeToUse = size !== null && size !== void 0 ? size : 10;
        const hits = [];
        for (let i = 0; i < sizeToUse; i++) {
          hits.push({
            type: 'dashboard',
            id: `dashboard${i}`,
            attributes: {
              description: `dashboard${i} desc`,
              title: `dashboard${i} - ${search} - title`
            },
            references: []
          });
        }
        return Promise.resolve({
          total: sizeToUse,
          hits
        });
      }),
      findByIds: jest.fn().mockImplementation(() => Promise.resolve([{
        id: `dashboardUnsavedOne`,
        status: 'success',
        attributes: {
          title: `Dashboard Unsaved One`
        }
      }, {
        id: `dashboardUnsavedTwo`,
        status: 'success',
        attributes: {
          title: `Dashboard Unsaved Two`
        }
      }, {
        id: `dashboardUnsavedThree`,
        status: 'success',
        attributes: {
          title: `Dashboard Unsaved Three`
        }
      }])),
      findByTitle: jest.fn()
    },
    checkForDuplicateDashboardTitle: jest.fn(),
    savedObjectsClient
  };
};
exports.dashboardSavedObjectServiceFactory = dashboardSavedObjectServiceFactory;