"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardUnsavedListing = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _confirm_overlays = require("./confirm_overlays");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _dashboard_session_storage_service = require("../services/dashboard_session_storage/dashboard_session_storage_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardUnsavedItem = ({
  id,
  title,
  onOpenClick,
  onDiscardClick
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dshUnsavedListingItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    className: "dshUnsavedListingItem__heading",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "text",
    className: "dshUnsavedListingItem__icon",
    type: title ? 'dashboardApp' : 'clock'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    className: `dshUnsavedListingItem__title ${title ? '' : 'dshUnsavedListingItem__loading'}`
  }, title || _dashboard_listing_strings.dashboardUnsavedListingStrings.getLoadingTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "none",
    className: "dshUnsavedListingItem__actions",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    color: "primary",
    disabled: !title,
    onClick: onOpenClick,
    "data-test-subj": title ? `edit-unsaved-${title.split(' ').join('-')}` : undefined,
    "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditAriaLabel(title !== null && title !== void 0 ? title : id)
  }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    color: "danger",
    disabled: !title,
    onClick: onDiscardClick,
    "data-test-subj": title ? `discard-unsaved-${title.split(' ').join('-')}` : undefined,
    "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardAriaLabel(title !== null && title !== void 0 ? title : id)
  }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardTitle()))));
};
const DashboardUnsavedListing = ({
  goToDashboard,
  unsavedDashboardIds,
  refreshUnsavedDashboards
}) => {
  const {
    dashboardSessionStorage,
    dashboardSavedObject: {
      savedObjectsClient,
      findDashboards
    }
  } = _plugin_services.pluginServices.getServices();
  const [items, setItems] = (0, _react.useState)({});
  const onOpen = (0, _react.useCallback)(id => {
    goToDashboard(id, _public.ViewMode.EDIT);
  }, [goToDashboard]);
  const onDiscard = (0, _react.useCallback)(id => {
    (0, _confirm_overlays.confirmDiscardUnsavedChanges)(() => {
      dashboardSessionStorage.clearState(id);
      refreshUnsavedDashboards();
    });
  }, [refreshUnsavedDashboards, dashboardSessionStorage]);
  (0, _react.useEffect)(() => {
    if ((unsavedDashboardIds === null || unsavedDashboardIds === void 0 ? void 0 : unsavedDashboardIds.length) === 0) {
      return;
    }
    let canceled = false;
    const existingDashboardsWithUnsavedChanges = unsavedDashboardIds.filter(id => id !== _dashboard_session_storage_service.DASHBOARD_PANELS_UNSAVED_ID);
    findDashboards.findByIds(existingDashboardsWithUnsavedChanges).then(results => {
      const dashboardMap = {};
      if (canceled) {
        return;
      }
      let hasError = false;
      const newItems = results.reduce((map, result) => {
        if (result.status === 'error') {
          hasError = true;
          dashboardSessionStorage.clearState(result.id);
          return map;
        }
        return {
          ...map,
          [result.id || _dashboard_session_storage_service.DASHBOARD_PANELS_UNSAVED_ID]: result.attributes
        };
      }, dashboardMap);
      if (hasError) {
        refreshUnsavedDashboards();
        return;
      }
      setItems(newItems);
    });
    return () => {
      canceled = true;
    };
  }, [refreshUnsavedDashboards, dashboardSessionStorage, unsavedDashboardIds, savedObjectsClient, findDashboards]);
  return unsavedDashboardIds.length === 0 ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    heading: "h3",
    title: _dashboard_listing_strings.dashboardUnsavedListingStrings.getUnsavedChangesTitle(unsavedDashboardIds.length > 1)
  }, unsavedDashboardIds.map(dashboardId => {
    var _items$dashboardId;
    const title = dashboardId === _dashboard_session_storage_service.DASHBOARD_PANELS_UNSAVED_ID ? (0, _dashboard_listing_strings.getNewDashboardTitle)() : (_items$dashboardId = items[dashboardId]) === null || _items$dashboardId === void 0 ? void 0 : _items$dashboardId.title;
    const redirectId = dashboardId === _dashboard_session_storage_service.DASHBOARD_PANELS_UNSAVED_ID ? undefined : dashboardId;
    return /*#__PURE__*/_react.default.createElement(DashboardUnsavedItem, {
      key: dashboardId,
      id: dashboardId,
      title: title,
      onOpenClick: () => onOpen(redirectId),
      onDiscardClick: () => onDiscard(redirectId)
    });
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.DashboardUnsavedListing = DashboardUnsavedListing;