"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = void 0;
require("../_dashboard_container.scss");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _classnames = _interopRequireDefault(require("classnames"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _dashboard_api = require("./dashboard_api");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const DashboardRenderer = /*#__PURE__*/(0, _react.forwardRef)(({
  savedObjectId,
  getCreationOptions,
  showPlainSpinner
}, ref) => {
  const dashboardRoot = (0, _react.useRef)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  const [screenshotMode, setScreenshotMode] = (0, _react.useState)(false);
  const [dashboardContainer, setDashboardContainer] = (0, _react.useState)();
  const [fatalError, setFatalError] = (0, _react.useState)();
  (0, _react.useImperativeHandle)(ref, () => (0, _dashboard_api.buildApiFromDashboardContainer)(dashboardContainer), [dashboardContainer]);
  (0, _react.useEffect)(() => {
    (async () => {
      // Lazy loading all services is required in this component because it is exported and contributes to the bundle size.
      const {
        pluginServices
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../services/plugin_services')));
      const {
        screenshotMode: {
          isScreenshotMode
        }
      } = pluginServices.getServices();
      setScreenshotMode(isScreenshotMode());
    })();
  }, []);
  const id = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  (0, _react.useEffect)(() => {
    if (dashboardContainer) {
      // When a dashboard already exists, don't rebuild it, just set a new id.
      dashboardContainer.navigateToDashboard(savedObjectId);
      return;
    }
    setLoading(true);
    let canceled = false;
    (async () => {
      fatalError === null || fatalError === void 0 ? void 0 : fatalError.destroy();
      setFatalError(undefined);
      const creationOptions = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());

      // Lazy loading all services is required in this component because it is exported and contributes to the bundle size.
      const {
        pluginServices
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../services/plugin_services')));
      const {
        embeddable
      } = pluginServices.getServices();
      const dashboardFactory = embeddable.getEmbeddableFactory(_.DASHBOARD_CONTAINER_TYPE);
      const container = await (dashboardFactory === null || dashboardFactory === void 0 ? void 0 : dashboardFactory.create({
        id
      },
      // Input from creationOptions is used instead.
      undefined, creationOptions, savedObjectId));
      if (canceled) {
        container.destroy();
        return;
      }
      setLoading(false);
      if ((0, _public.isErrorEmbeddable)(container)) {
        setFatalError(container);
        return;
      }
      if (dashboardRoot.current) {
        container.render(dashboardRoot.current);
      }
      setDashboardContainer(container);
    })();
    return () => {
      canceled = true;
    };
    // Disabling exhaustive deps because embeddable should only be created on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedObjectId]);
  (0, _useUnmount.default)(() => {
    fatalError === null || fatalError === void 0 ? void 0 : fatalError.destroy();
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.destroy();
  });
  const viewportClasses = (0, _classnames.default)('dashboardViewport', {
    'dashboardViewport--screenshotMode': screenshotMode
  }, {
    'dashboardViewport--loading': loading
  });
  const loadingSpinner = showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xxl"
  });
  const renderDashboardContents = () => {
    if (fatalError) return fatalError.render();
    if (loading) return loadingSpinner;
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: dashboardRoot
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: viewportClasses
  }, renderDashboardContents());
});
exports.DashboardRenderer = DashboardRenderer;