"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showCloneModal = showCloneModal;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _clone_modal = require("./clone_modal");
var _plugin_services = require("../../../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function showCloneModal({
  onClone,
  title,
  onClose
}) {
  const {
    settings: {
      theme
    }
  } = _plugin_services.pluginServices.getServices();
  const container = document.createElement('div');
  const closeModal = () => {
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    onClose();
  };
  const onCloneConfirmed = async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
    onClone(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate).then(response => {
      // The only time you don't want to close the modal is if it's asking you
      // to confirm a duplicate title, in which case there will be no error and no id.
      if (response.error || response.id) {
        closeModal();
      }
    });
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_clone_modal.DashboardCloneModal, {
    onClone: onCloneConfirmed,
    onClose: closeModal,
    title: _i18n.i18n.translate('dashboard.topNav.showCloneModal.dashboardCopyTitle', {
      defaultMessage: '{title} Copy',
      values: {
        title
      }
    })
  })));
  _reactDom.default.render(element, container);
}