"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardCloneModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DashboardCloneModal extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isMounted", false);
    (0, _defineProperty2.default)(this, "onTitleDuplicate", () => {
      this.setState({
        isTitleDuplicateConfirmed: true,
        hasTitleDuplicate: true
      });
    });
    (0, _defineProperty2.default)(this, "cloneDashboard", async () => {
      this.setState({
        isLoading: true
      });
      await this.props.onClone(this.state.newDashboardName, this.state.isTitleDuplicateConfirmed, this.onTitleDuplicate);
      if (this.isMounted) {
        this.setState({
          isLoading: false
        });
      }
    });
    (0, _defineProperty2.default)(this, "onInputChange", event => {
      this.setState({
        newDashboardName: event.target.value,
        isTitleDuplicateConfirmed: false,
        hasTitleDuplicate: false
      });
    });
    (0, _defineProperty2.default)(this, "renderDuplicateTitleCallout", () => {
      if (!this.state.hasTitleDuplicate) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        title: _i18n.i18n.translate('dashboard.topNav.cloneModal.dashboardExistsTitle', {
          defaultMessage: 'A dashboard with the title {newDashboardName} already exists.',
          values: {
            newDashboardName: `'${this.state.newDashboardName}'`
          }
        }),
        color: "warning",
        "data-test-subj": "titleDupicateWarnMsg"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.cloneModal.dashboardExistsDescription",
        defaultMessage: "Click {confirmClone} to clone the dashboard with the duplicate title.",
        values: {
          confirmClone: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "dashboard.topNav.cloneModal.confirmCloneDescription",
            defaultMessage: "Confirm Clone"
          }))
        }
      }))));
    });
    this.state = {
      newDashboardName: props.title,
      isTitleDuplicateConfirmed: false,
      hasTitleDuplicate: false,
      isLoading: false
    };
  }
  componentDidMount() {
    this.isMounted = true;
  }
  componentWillUnmount() {
    this.isMounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "dashboardCloneModal",
      className: "dshCloneModal",
      onClose: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.topNav.cloneModal.cloneDashboardModalHeaderTitle",
      defaultMessage: "Clone dashboard"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.topNav.cloneModal.enterNewNameForDashboardDescription",
      defaultMessage: "Please enter a new name for your dashboard."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      autoFocus: true,
      "aria-label": _i18n.i18n.translate('dashboard.cloneModal.cloneDashboardTitleAriaLabel', {
        defaultMessage: 'Cloned Dashboard Title'
      }),
      "data-test-subj": "clonedDashboardTitle",
      value: this.state.newDashboardName,
      onChange: this.onInputChange,
      isInvalid: this.state.hasTitleDuplicate
    }), this.renderDuplicateTitleCallout()), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "cloneCancelButton",
      onClick: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.topNav.cloneModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "cloneConfirmButton",
      onClick: this.cloneDashboard,
      isLoading: this.state.isLoading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.topNav.cloneModal.confirmButtonLabel",
      defaultMessage: "Confirm Clone"
    }))));
  }
}
exports.DashboardCloneModal = DashboardCloneModal;