"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFromLibrary = addFromLibrary;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/saved-objects-finder-plugin/public");
var _plugin_services = require("../../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function addFromLibrary() {
  const {
    overlays,
    notifications,
    usageCollection,
    settings: {
      uiSettings,
      theme
    },
    embeddable: {
      getEmbeddableFactories,
      getEmbeddableFactory
    },
    http,
    savedObjectsManagement,
    savedObjectsTagging
  } = _plugin_services.pluginServices.getServices();
  if ((0, _public.isErrorEmbeddable)(this)) return;
  this.openOverlay((0, _public.openAddPanelFlyout)({
    SavedObjectFinder: (0, _public2.getSavedObjectFinder)(uiSettings, http, savedObjectsManagement, savedObjectsTagging.api),
    reportUiCounter: usageCollection.reportUiCounter,
    getAllFactories: getEmbeddableFactories,
    getFactory: getEmbeddableFactory,
    embeddable: this,
    notifications,
    overlays,
    theme,
    onAddPanel: id => {
      this.setScrollToPanelId(id);
      this.setHighlightPanelId(id);
    }
  }));
}