"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPanelState = createPanelState;
var _dashboard_panel_placement = require("./dashboard_panel_placement");
var _dashboard_constants = require("../../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates and initializes a basic panel state.
 */
function createPanelState(panelState, currentPanels, placementMethod, placementArgs) {
  const defaultPlacementArgs = {
    width: _dashboard_constants.DEFAULT_PANEL_WIDTH,
    height: _dashboard_constants.DEFAULT_PANEL_HEIGHT,
    currentPanels
  };
  const finalPlacementArgs = placementArgs ? {
    ...defaultPlacementArgs,
    ...placementArgs
  } : defaultPlacementArgs;
  const {
    newPanelPlacement,
    otherPanels
  } = placementMethod ? placementMethod(finalPlacementArgs) : (0, _dashboard_panel_placement.findTopLeftMostOpenSpace)(defaultPlacementArgs);
  return {
    newPanel: {
      gridData: {
        ...newPanelPlacement,
        i: panelState.explicitInput.id
      },
      ...panelState
    },
    otherPanels
  };
}