"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardGridSettings = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _dashboard_constants = require("../../../dashboard_constants");
var _dashboard_container = require("../../embeddable/dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDashboardGridSettings = panelsInOrder => {
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const panels = dashboard.select(state => state.explicitInput.panels);
  const viewMode = dashboard.select(state => state.explicitInput.viewMode);
  const layouts = (0, _react.useMemo)(() => {
    return {
      lg: panelsInOrder.map(embeddableId => panels[embeddableId].gridData)
    };
  }, [panels, panelsInOrder]);
  const breakpoints = (0, _react.useMemo)(() => ({
    lg: euiTheme.breakpoint.m,
    ...(viewMode === _public.ViewMode.VIEW ? {
      sm: 0
    } : {})
  }), [viewMode, euiTheme.breakpoint.m]);
  const columns = (0, _react.useMemo)(() => ({
    lg: _dashboard_constants.DASHBOARD_GRID_COLUMN_COUNT,
    ...(viewMode === _public.ViewMode.VIEW ? {
      sm: 1
    } : {})
  }), [viewMode]);
  return {
    layouts,
    breakpoints,
    columns
  };
};
exports.useDashboardGridSettings = useDashboardGridSettings;