"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservedItem = exports.DashboardGridItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/embeddable-plugin/public");
var _plugin_services = require("../../../services/plugin_services");
var _dashboard_container = require("../../embeddable/dashboard_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Item = /*#__PURE__*/_react.default.forwardRef(({
  expandedPanelId,
  focusedPanelId,
  id,
  index,
  type,
  onPanelStatusChange,
  isRenderable = true,
  // The props below are passed from ReactGridLayoutn and need to be merged with their counterparts.
  // https://github.com/react-grid-layout/react-grid-layout/issues/1241#issuecomment-658306889
  children,
  className,
  style,
  ...rest
}, ref) => {
  const {
    embeddable: {
      EmbeddablePanel: PanelComponent
    }
  } = _plugin_services.pluginServices.getServices();
  const container = (0, _dashboard_container.useDashboardContainer)();
  const scrollToPanelId = container.select(state => state.componentState.scrollToPanelId);
  const highlightPanelId = container.select(state => state.componentState.highlightPanelId);
  const expandPanel = expandedPanelId !== undefined && expandedPanelId === id;
  const hidePanel = expandedPanelId !== undefined && expandedPanelId !== id;
  const classes = (0, _classnames.default)({
    'dshDashboardGrid__item--expanded': expandPanel,
    'dshDashboardGrid__item--hidden': hidePanel,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    printViewport__vis: container.getInput().viewMode === _public.ViewMode.PRINT
  });
  (0, _react.useLayoutEffect)(() => {
    if (typeof ref !== 'function' && ref !== null && ref !== void 0 && ref.current) {
      if (scrollToPanelId === id) {
        container.scrollToPanel(ref.current);
      }
      if (highlightPanelId === id) {
        container.highlightPanel(ref.current);
      }
    }
  }, [id, container, scrollToPanelId, highlightPanelId, ref]);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    style: {
      ...style,
      zIndex: focusedPanelId === id ? 2 : 'auto'
    },
    className: [classes, className].join(' '),
    "data-test-subj": "dashboardPanel",
    id: `panel-${id}`,
    ref: ref
  }, rest), isRenderable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.EmbeddableChildPanel
  // This key is used to force rerendering on embeddable type change while the id remains the same
  , {
    key: type,
    embeddableId: id,
    index: index,
    onPanelStatusChange: onPanelStatusChange,
    container,
    PanelComponent
  }), children) : /*#__PURE__*/_react.default.createElement("div", {
    className: "embPanel embPanel-isLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    mono: true
  })));
});
const ObservedItem = /*#__PURE__*/_react.default.forwardRef((props, panelRef) => {
  const [intersection, updateIntersection] = (0, _react.useState)();
  const [isRenderable, setIsRenderable] = (0, _react.useState)(false);
  const observerRef = (0, _react.useRef)(new window.IntersectionObserver(([value]) => updateIntersection(value), {
    root: panelRef.current
  }));
  (0, _react.useEffect)(() => {
    const {
      current: currentObserver
    } = observerRef;
    currentObserver.disconnect();
    const {
      current
    } = panelRef;
    if (current) {
      currentObserver.observe(current);
    }
    return () => currentObserver.disconnect();
  }, [panelRef]);
  (0, _react.useEffect)(() => {
    if (intersection !== null && intersection !== void 0 && intersection.isIntersecting && !isRenderable) {
      setIsRenderable(true);
    }
  }, [intersection, isRenderable]);
  return /*#__PURE__*/_react.default.createElement(Item, (0, _extends2.default)({
    ref: panelRef,
    isRenderable: isRenderable
  }, props));
});

// ReactGridLayout passes ref to children. Functional component children require forwardRef to avoid react warning
// https://github.com/react-grid-layout/react-grid-layout#custom-child-components-and-draggable-handles
exports.ObservedItem = ObservedItem;
const DashboardGridItem = /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  const {
    settings: {
      isProjectEnabledInLabs
    }
  } = _plugin_services.pluginServices.getServices();
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const isPrintMode = dashboard.select(state => state.explicitInput.viewMode) === _public.ViewMode.PRINT;
  const isEnabled = !isPrintMode && isProjectEnabledInLabs('labs:dashboard:deferBelowFold');
  return isEnabled ? /*#__PURE__*/_react.default.createElement(ObservedItem, (0, _extends2.default)({
    ref: ref
  }, props)) : /*#__PURE__*/_react.default.createElement(Item, (0, _extends2.default)({
    ref: ref
  }, props));
});
exports.DashboardGridItem = DashboardGridItem;