"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEmptyScreen = DashboardEmptyScreen;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _plugin_services = require("../../../services/plugin_services");
var _dashboard_container_strings = require("../../_dashboard_container_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardEmptyScreen({
  isEditMode
}) {
  const {
    dashboardCapabilities: {
      showWriteControls
    },
    http: {
      basePath
    },
    settings: {
      uiSettings
    }
  } = _plugin_services.pluginServices.getServices();
  const isReadonlyMode = !showWriteControls;
  const IS_DARK_THEME = uiSettings.get('theme:darkMode');
  const emptyStateGraphicURL = IS_DARK_THEME ? '/plugins/home/assets/welcome_graphic_dark_2x.png' : '/plugins/home/assets/welcome_graphic_light_2x.png';
  const page = (mainText, showAdditionalParagraph, additionalText) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      "data-test-subj": isReadonlyMode ? 'dashboardEmptyReadOnly' : 'dashboardEmptyReadWrite',
      className: "dshStartScreen",
      restrictWidth: "500px"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      paddingSize: "none",
      className: "dshStartScreen__pageContent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: basePath.prepend(emptyStateGraphicURL),
      alt: ""
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        fontWeight: 'bold'
      }
    }, mainText)), additionalText ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: "subdued"
    }, additionalText) : null, showAdditionalParagraph ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "dshStartScreen__panelDesc"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _dashboard_container_strings.emptyScreenStrings.getHowToStartWorkingOnNewDashboardDescription())))) : null)));
  };
  const readonlyMode = page(_dashboard_container_strings.emptyScreenStrings.getEmptyDashboardTitle(), false, _dashboard_container_strings.emptyScreenStrings.getEmptyDashboardAdditionalPrivilege());
  const viewMode = page(_dashboard_container_strings.emptyScreenStrings.getFillDashboardTitle(), true);
  const editMode = /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "emptyDashboardWidget",
    className: "dshEmptyWidget"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    size: "xl",
    type: "visAreaStacked"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _dashboard_container_strings.emptyScreenStrings.getEmptyWidgetTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, _dashboard_container_strings.emptyScreenStrings.getEmptyWidgetDescription())));
  const actionableMode = isEditMode ? editMode : viewMode;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, isReadonlyMode ? readonlyMode : actionableMode);
}