"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.panelStorageErrorStrings = exports.emptyScreenStrings = exports.dashboardSavedObjectErrorStrings = exports.dashboardSaveToastStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
  Empty Screen
*/
const emptyScreenStrings = {
  getEmptyDashboardTitle: () => _i18n.i18n.translate('dashboard.emptyDashboardTitle', {
    defaultMessage: 'This dashboard is empty.'
  }),
  getEmptyDashboardAdditionalPrivilege: () => _i18n.i18n.translate('dashboard.emptyDashboardAdditionalPrivilege', {
    defaultMessage: 'You need additional privileges to edit this dashboard.'
  }),
  getFillDashboardTitle: () => _i18n.i18n.translate('dashboard.fillDashboardTitle', {
    defaultMessage: 'This dashboard is empty. Let\u2019s fill it up!'
  }),
  getHowToStartWorkingOnNewDashboardDescription: () => _i18n.i18n.translate('dashboard.howToStartWorkingOnNewDashboardDescription', {
    defaultMessage: 'Click edit in the menu bar above to start adding panels.'
  }),
  getHowToStartWorkingOnNewDashboardEditLinkAriaLabel: () => _i18n.i18n.translate('dashboard.howToStartWorkingOnNewDashboardEditLinkAriaLabel', {
    defaultMessage: 'Edit dashboard'
  }),
  getEmptyWidgetTitle: () => _i18n.i18n.translate('dashboard.emptyWidget.addPanelTitle', {
    defaultMessage: 'Add your first visualization'
  }),
  getEmptyWidgetDescription: () => _i18n.i18n.translate('dashboard.emptyWidget.addPanelDescription', {
    defaultMessage: 'Create content that tells a story about your data.'
  })
};
exports.emptyScreenStrings = emptyScreenStrings;
const dashboardSaveToastStrings = {
  getSuccessString: dashTitle => _i18n.i18n.translate('dashboard.dashboardWasSavedSuccessMessage', {
    defaultMessage: `Dashboard '{dashTitle}' was saved`,
    values: {
      dashTitle
    }
  }),
  getFailureString: (dashTitle, errorMessage) => _i18n.i18n.translate('dashboard.dashboardWasNotSavedDangerMessage', {
    defaultMessage: `Dashboard '{dashTitle}' was not saved. Error: {errorMessage}`,
    values: {
      dashTitle,
      errorMessage
    }
  })
};
exports.dashboardSaveToastStrings = dashboardSaveToastStrings;
const dashboardSavedObjectErrorStrings = {
  getDashboardGridError: message => _i18n.i18n.translate('dashboard.loadingError.dashboardGridErrorMessage', {
    defaultMessage: 'Unable to load dashboard: {message}',
    values: {
      message
    }
  }),
  getErrorDeletingDashboardToast: () => _i18n.i18n.translate('dashboard.deleteError.toastDescription', {
    defaultMessage: 'Error encountered while deleting dashboard'
  })
};
exports.dashboardSavedObjectErrorStrings = dashboardSavedObjectErrorStrings;
const panelStorageErrorStrings = {
  getPanelsGetError: message => _i18n.i18n.translate('dashboard.panelStorageError.getError', {
    defaultMessage: 'Error encountered while fetching unsaved changes: {message}',
    values: {
      message
    }
  }),
  getPanelsSetError: message => _i18n.i18n.translate('dashboard.panelStorageError.setError', {
    defaultMessage: 'Error encountered while setting unsaved changes: {message}',
    values: {
      message
    }
  }),
  getPanelsClearError: message => _i18n.i18n.translate('dashboard.panelStorageError.clearError', {
    defaultMessage: 'Error encountered while clearing unsaved changes: {message}',
    values: {
      message
    }
  })
};
exports.panelStorageErrorStrings = panelStorageErrorStrings;