"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DASHBOARD_URL = exports.SEARCH_SESSION_ID = exports.SAVED_OBJECT_POST_TIME = exports.SAVED_OBJECT_LOADED_TIME = exports.SAVED_OBJECT_DELETE_TIME = exports.PRINT_DASHBOARD_URL = exports.LEGACY_DASHBOARD_APP_ID = exports.LANDING_PAGE_PATH = exports.GLOBAL_STATE_STORAGE_KEY = exports.DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_HEIGHT = exports.DEFAULT_DASHBOARD_INPUT = exports.DASHBOARD_UI_METRIC_ID = exports.DASHBOARD_STATE_STORAGE_KEY = exports.DASHBOARD_SAVED_OBJECT_TYPE = exports.DASHBOARD_MARGIN_SIZE = exports.DASHBOARD_LOADED_EVENT = exports.DASHBOARD_GRID_HEIGHT = exports.DASHBOARD_GRID_COLUMN_COUNT = exports.DASHBOARD_APP_ID = exports.CREATE_NEW_DASHBOARD_URL = exports.CHANGE_CHECK_DEBOUNCE = void 0;
exports.createDashboardEditUrl = createDashboardEditUrl;
exports.createDashboardListingFilterUrl = createDashboardListingFilterUrl;
exports.getFullPath = exports.getFullEditPath = void 0;
var _common = require("@kbn/embeddable-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// ------------------------------------------------------------------
// URL Constants
// ------------------------------------------------------------------
const DASHBOARD_STATE_STORAGE_KEY = '_a';
exports.DASHBOARD_STATE_STORAGE_KEY = DASHBOARD_STATE_STORAGE_KEY;
const GLOBAL_STATE_STORAGE_KEY = '_g';
exports.GLOBAL_STATE_STORAGE_KEY = GLOBAL_STATE_STORAGE_KEY;
const LANDING_PAGE_PATH = '/list';
exports.LANDING_PAGE_PATH = LANDING_PAGE_PATH;
const CREATE_NEW_DASHBOARD_URL = '/create';
exports.CREATE_NEW_DASHBOARD_URL = CREATE_NEW_DASHBOARD_URL;
const VIEW_DASHBOARD_URL = '/view';
exports.VIEW_DASHBOARD_URL = VIEW_DASHBOARD_URL;
const PRINT_DASHBOARD_URL = '/print';
exports.PRINT_DASHBOARD_URL = PRINT_DASHBOARD_URL;
const getFullPath = (aliasId, id) => `/app/dashboards#${createDashboardEditUrl(aliasId || id)}`;
exports.getFullPath = getFullPath;
const getFullEditPath = (id, editMode) => {
  return `/app/dashboards#${createDashboardEditUrl(id, editMode)}`;
};
exports.getFullEditPath = getFullEditPath;
function createDashboardEditUrl(id, editMode) {
  if (!id) {
    return `${CREATE_NEW_DASHBOARD_URL}`;
  }
  const edit = editMode ? `?${DASHBOARD_STATE_STORAGE_KEY}=(viewMode:edit)` : '';
  return `${VIEW_DASHBOARD_URL}/${id}${edit}`;
}
function createDashboardListingFilterUrl(filter) {
  return filter ? `${LANDING_PAGE_PATH}?filter="${filter}"` : LANDING_PAGE_PATH;
}

// ------------------------------------------------------------------
// Telemetry & Events
// ------------------------------------------------------------------
const DASHBOARD_LOADED_EVENT = 'dashboard_loaded';
exports.DASHBOARD_LOADED_EVENT = DASHBOARD_LOADED_EVENT;
const SAVED_OBJECT_LOADED_TIME = 'saved_object_loaded_time';
exports.SAVED_OBJECT_LOADED_TIME = SAVED_OBJECT_LOADED_TIME;
const SAVED_OBJECT_DELETE_TIME = 'saved_object_delete_time';
exports.SAVED_OBJECT_DELETE_TIME = SAVED_OBJECT_DELETE_TIME;
const SAVED_OBJECT_POST_TIME = 'saved_object_post_time';
exports.SAVED_OBJECT_POST_TIME = SAVED_OBJECT_POST_TIME;
const DASHBOARD_UI_METRIC_ID = 'dashboard';

// ------------------------------------------------------------------
// IDs
// ------------------------------------------------------------------
exports.DASHBOARD_UI_METRIC_ID = DASHBOARD_UI_METRIC_ID;
const DASHBOARD_APP_ID = 'dashboards';
exports.DASHBOARD_APP_ID = DASHBOARD_APP_ID;
const LEGACY_DASHBOARD_APP_ID = 'dashboard';
exports.LEGACY_DASHBOARD_APP_ID = LEGACY_DASHBOARD_APP_ID;
const SEARCH_SESSION_ID = 'searchSessionId';
exports.SEARCH_SESSION_ID = SEARCH_SESSION_ID;
const DASHBOARD_SAVED_OBJECT_TYPE = 'dashboard';

// ------------------------------------------------------------------
// Grid
// ------------------------------------------------------------------
exports.DASHBOARD_SAVED_OBJECT_TYPE = DASHBOARD_SAVED_OBJECT_TYPE;
const DEFAULT_PANEL_HEIGHT = 15;
exports.DEFAULT_PANEL_HEIGHT = DEFAULT_PANEL_HEIGHT;
const DASHBOARD_MARGIN_SIZE = 8;
exports.DASHBOARD_MARGIN_SIZE = DASHBOARD_MARGIN_SIZE;
const DASHBOARD_GRID_HEIGHT = 20;
exports.DASHBOARD_GRID_HEIGHT = DASHBOARD_GRID_HEIGHT;
const DASHBOARD_GRID_COLUMN_COUNT = 48;
exports.DASHBOARD_GRID_COLUMN_COUNT = DASHBOARD_GRID_COLUMN_COUNT;
const DEFAULT_PANEL_WIDTH = DASHBOARD_GRID_COLUMN_COUNT / 2;
exports.DEFAULT_PANEL_WIDTH = DEFAULT_PANEL_WIDTH;
const CHANGE_CHECK_DEBOUNCE = 100;

// ------------------------------------------------------------------
// Default State
// ------------------------------------------------------------------
exports.CHANGE_CHECK_DEBOUNCE = CHANGE_CHECK_DEBOUNCE;
const DEFAULT_DASHBOARD_INPUT = {
  viewMode: _common.ViewMode.EDIT,
  // new dashboards start in  edit mode.
  timeRestore: false,
  query: {
    query: '',
    language: 'kuery'
  },
  description: '',
  filters: [],
  panels: {},
  title: '',
  tags: [],
  // options
  useMargins: true,
  syncColors: false,
  syncCursor: true,
  syncTooltips: false,
  hidePanelTitles: false
};
exports.DEFAULT_DASHBOARD_INPUT = DEFAULT_DASHBOARD_INPUT;