"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionRestorationDataProvider = createSessionRestorationDataProvider;
exports.removeSearchSessionIdFromURL = exports.getSessionURLObservable = exports.getSearchSessionIdFromURL = void 0;
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _dashboard_constants = require("../../dashboard_constants");
var _common2 = require("../../../common");
var _plugin_services = require("../../services/plugin_services");
var _locator = require("../locator/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const removeSearchSessionIdFromURL = kbnUrlStateStorage => {
  kbnUrlStateStorage.kbnUrlControls.updateAsync(nextUrl => {
    if (nextUrl.includes(_dashboard_constants.SEARCH_SESSION_ID)) {
      return (0, _common.replaceUrlHashQuery)(nextUrl, hashQuery => {
        delete hashQuery[_dashboard_constants.SEARCH_SESSION_ID];
        return hashQuery;
      });
    }
    return nextUrl;
  });
};
exports.removeSearchSessionIdFromURL = removeSearchSessionIdFromURL;
const getSearchSessionIdFromURL = history => (0, _public.getQueryParams)(history.location)[_dashboard_constants.SEARCH_SESSION_ID];
exports.getSearchSessionIdFromURL = getSearchSessionIdFromURL;
const getSessionURLObservable = history => (0, _public.createQueryParamObservable)(history, _dashboard_constants.SEARCH_SESSION_ID).pipe((0, _rxjs.map)(sessionId => sessionId !== null && sessionId !== void 0 ? sessionId : undefined));
exports.getSessionURLObservable = getSessionURLObservable;
function createSessionRestorationDataProvider(container) {
  return {
    getName: async () => container.getTitle(),
    getLocatorData: async () => ({
      id: _locator.DASHBOARD_APP_LOCATOR,
      initialState: getLocatorParams({
        container,
        shouldRestoreSearchSession: false
      }),
      restoreState: getLocatorParams({
        container,
        shouldRestoreSearchSession: true
      })
    })
  };
}

/**
 * Fetches the state to store when a session is saved so that this dashboard can be recreated exactly
 * as it was.
 */
function getLocatorParams({
  container,
  shouldRestoreSearchSession
}) {
  const {
    data: {
      query: {
        queryString,
        filterManager,
        timefilter: {
          timefilter
        }
      },
      search: {
        session
      }
    },
    initializerContext: {
      kibanaVersion
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    componentState: {
      lastSavedId
    },
    explicitInput: {
      panels,
      query,
      viewMode
    }
  } = container.getState();
  return {
    viewMode,
    useHash: false,
    preserveSavedFilters: false,
    filters: filterManager.getFilters(),
    query: queryString.formatQuery(query),
    dashboardId: container.getDashboardSavedObjectId(),
    searchSessionId: shouldRestoreSearchSession ? session.getSessionId() : undefined,
    timeRange: shouldRestoreSearchSession ? timefilter.getAbsoluteTime() : timefilter.getTime(),
    refreshInterval: shouldRestoreSearchSession ? {
      pause: true,
      // force pause refresh interval when restoring a session
      value: 0
    } : undefined,
    panels: lastSavedId ? undefined : (0, _common2.convertPanelMapToSavedPanels)(panels, kibanaVersion)
  };
}