"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _public = require("@kbn/visualizations-plugin/public");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EditorMenu = ({
  createNewVisType,
  createNewEmbeddable
}) => {
  const {
    embeddable,
    settings: {
      uiSettings
    },
    visualizations: {
      getAliases: getVisTypeAliases,
      getByGroup: getVisTypesByGroup,
      showNewVisModal
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const embeddableFactories = (0, _react.useMemo)(() => Array.from(embeddable.getEmbeddableFactories()), [embeddable]);
  const [unwrappedEmbeddableFactories, setUnwrappedEmbeddableFactories] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    Promise.all(embeddableFactories.map(async factory => ({
      factory,
      isEditable: await factory.isEditable()
    }))).then(factories => {
      setUnwrappedEmbeddableFactories(factories);
    });
  }, [embeddableFactories]);
  const LABS_ENABLED = uiSettings.get('visualize:enableLabs');
  const createNewAggsBasedVis = (0, _react.useCallback)(visType => () => showNewVisModal({
    originatingApp: _dashboard_constants.DASHBOARD_APP_ID,
    outsideVisualizeApp: true,
    showAggsSelection: true,
    selectedVisType: visType
  }), [showNewVisModal]);
  const getSortedVisTypesByGroup = group => getVisTypesByGroup(group).sort(({
    name: a
  }, {
    name: b
  }) => {
    if (a < b) {
      return -1;
    }
    if (a > b) {
      return 1;
    }
    return 0;
  }).filter(({
    hidden,
    stage
  }) => !(hidden || !LABS_ENABLED && stage === 'experimental'));
  const promotedVisTypes = getSortedVisTypesByGroup(_public.VisGroups.PROMOTED);
  const aggsBasedVisTypes = getSortedVisTypesByGroup(_public.VisGroups.AGGBASED);
  const toolVisTypes = getSortedVisTypesByGroup(_public.VisGroups.TOOLS);
  const visTypeAliases = getVisTypeAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1);
  const factories = unwrappedEmbeddableFactories.filter(({
    isEditable,
    factory: {
      type,
      canCreateNew,
      isContainerType
    }
  }) => isEditable && !isContainerType && canCreateNew() && type !== 'visualization');
  const factoryGroupMap = {};
  const ungroupedFactories = [];
  const aggBasedPanelID = 1;
  let panelCount = 1 + aggBasedPanelID;
  factories.forEach(({
    factory
  }) => {
    const {
      grouping
    } = factory;
    if (grouping) {
      grouping.forEach(group => {
        if (factoryGroupMap[group.id]) {
          factoryGroupMap[group.id].factories.push(factory);
        } else {
          factoryGroupMap[group.id] = {
            id: group.id,
            appName: group.getDisplayName ? group.getDisplayName({
              embeddable
            }) : group.id,
            icon: group.getIconType ? group.getIconType({
              embeddable
            }) : 'empty',
            factories: [factory],
            panelId: panelCount
          };
          panelCount++;
        }
      });
    } else {
      ungroupedFactories.push(factory);
    }
  });
  const getVisTypeMenuItem = visType => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty',
      group,
      isDeprecated
    } = visType;
    return {
      name: !isDeprecated ? titleInWizard || title : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, titleInWizard || title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, _i18n.i18n.translate('dashboard.editorMenu.deprecatedTag', {
        defaultMessage: 'Deprecated'
      })))),
      icon: icon,
      onClick:
      // not all the agg-based visualizations need to be created via the wizard
      group === _public.VisGroups.AGGBASED && visType.options.showIndexSelection ? createNewAggsBasedVis(visType) : createNewVisType(visType),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getVisTypeAliasMenuItem = visTypeAlias => {
    const {
      name,
      title,
      description,
      icon = 'empty'
    } = visTypeAlias;
    return {
      name: title,
      icon,
      onClick: createNewVisType(visTypeAlias),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getEmbeddableFactoryMenuItem = (factory, closePopover) => {
    const icon = factory !== null && factory !== void 0 && factory.getIconType ? factory.getIconType() : 'empty';
    const toolTipContent = factory !== null && factory !== void 0 && factory.getDescription ? factory.getDescription() : undefined;
    return {
      name: factory.getDisplayName(),
      icon,
      toolTipContent,
      onClick: async () => {
        closePopover();
        createNewEmbeddable(factory);
      },
      'data-test-subj': `createNew-${factory.type}`
    };
  };
  const aggsPanelTitle = _i18n.i18n.translate('dashboard.editorMenu.aggBasedGroupTitle', {
    defaultMessage: 'Aggregation based'
  });
  const getEditorMenuPanels = closePopover => {
    return [{
      id: 0,
      items: [...visTypeAliases.map(getVisTypeAliasMenuItem), ...Object.values(factoryGroupMap).map(({
        id,
        appName,
        icon,
        panelId
      }) => ({
        name: appName,
        icon,
        panel: panelId,
        'data-test-subj': `dashboardEditorMenu-${id}Group`
      })), ...ungroupedFactories.map(factory => {
        return getEmbeddableFactoryMenuItem(factory, closePopover);
      }), ...promotedVisTypes.map(getVisTypeMenuItem), {
        name: aggsPanelTitle,
        icon: 'visualizeApp',
        panel: aggBasedPanelID,
        'data-test-subj': `dashboardEditorAggBasedMenuItem`
      }, ...toolVisTypes.map(getVisTypeMenuItem)]
    }, {
      id: aggBasedPanelID,
      title: aggsPanelTitle,
      items: aggsBasedVisTypes.map(getVisTypeMenuItem)
    }, ...Object.values(factoryGroupMap).map(({
      appName,
      panelId,
      factories: groupFactories
    }) => ({
      id: panelId,
      title: appName,
      items: groupFactories.map(factory => {
        return getEmbeddableFactoryMenuItem(factory, closePopover);
      })
    }))];
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    zIndex: Number(euiTheme.levels.header) - 1,
    repositionOnScroll: true,
    ownFocus: true,
    label: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
      defaultMessage: 'Select type'
    }),
    panelPaddingSize: "none",
    "data-test-subj": "dashboardEditorMenuButton"
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: getEditorMenuPanels(closePopover),
    className: `dshSolutionToolbar__editorContextMenu`,
    "data-test-subj": "dashboardEditorContextMenu"
  }));
};
exports.EditorMenu = EditorMenu;