"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTopNav = DashboardTopNav;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/presentation-util-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _common = require("../../../common");
var _dashboard_app = require("../dashboard_app");
var _plugin_services = require("../../services/plugin_services");
var _use_dashboard_menu_items = require("./use_dashboard_menu_items");
var _dashboard_editing_toolbar = require("./dashboard_editing_toolbar");
var _dashboard_mount_context = require("../hooks/dashboard_mount_context");
var _dashboard_constants = require("../../dashboard_constants");
require("./_dashboard_top_nav.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LabsFlyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
function DashboardTopNav({
  embedSettings,
  redirectTo
}) {
  const [isChromeVisible, setIsChromeVisible] = (0, _react.useState)(false);
  const [isLabsShown, setIsLabsShown] = (0, _react.useState)(false);
  const dashboardTitleRef = (0, _react.useRef)(null);

  /**
   * Unpack dashboard services
   */
  const {
    data: {
      query: {
        filterManager
      }
    },
    chrome: {
      setBreadcrumbs,
      setIsVisible: setChromeVisibility,
      getIsVisible$: getChromeIsVisible$,
      recentlyAccessed: chromeRecentlyAccessed
    },
    settings: {
      uiSettings
    },
    navigation: {
      TopNavMenu
    },
    embeddable: {
      getStateTransfer
    },
    initializerContext: {
      allowByValueEmbeddables
    },
    dashboardCapabilities: {
      saveQuery: showSaveQuery
    }
  } = _plugin_services.pluginServices.getServices();
  const isLabsEnabled = uiSettings.get(_common.UI_SETTINGS.ENABLE_LABS_UI);
  const {
    setHeaderActionMenu,
    onAppLeave
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  const PresentationUtilContextProvider = (0, _public.getContextProvider)();
  const hasUnsavedChanges = dashboard.select(state => state.componentState.hasUnsavedChanges);
  const fullScreenMode = dashboard.select(state => state.componentState.fullScreenMode);
  const savedQueryId = dashboard.select(state => state.componentState.savedQueryId);
  const lastSavedId = dashboard.select(state => state.componentState.lastSavedId);
  const viewMode = dashboard.select(state => state.explicitInput.viewMode);
  const query = dashboard.select(state => state.explicitInput.query);
  const title = dashboard.select(state => state.explicitInput.title);

  // store data views in state & subscribe to dashboard data view changes.
  const [allDataViews, setAllDataViews] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setAllDataViews(dashboard.getAllDataViews());
    const subscription = dashboard.onDataViewsUpdate$.subscribe(dataViews => setAllDataViews(dataViews));
    return () => subscription.unsubscribe();
  }, [dashboard]);
  const dashboardTitle = (0, _react.useMemo)(() => {
    return (0, _dashboard_app_strings.getDashboardTitle)(title, viewMode, !lastSavedId);
  }, [title, viewMode, lastSavedId]);

  /**
   * focus on the top header when title or view mode is changed
   */
  (0, _react.useEffect)(() => {
    var _dashboardTitleRef$cu;
    (_dashboardTitleRef$cu = dashboardTitleRef.current) === null || _dashboardTitleRef$cu === void 0 ? void 0 : _dashboardTitleRef$cu.focus();
  }, [title, viewMode]);

  /**
   * Manage chrome visibility when dashboard is embedded.
   */
  (0, _react.useEffect)(() => {
    if (!embedSettings) setChromeVisibility(viewMode !== _public2.ViewMode.PRINT);
  }, [embedSettings, setChromeVisibility, viewMode]);

  /**
   * populate recently accessed, and set is chrome visible.
   */
  (0, _react.useEffect)(() => {
    const subscription = getChromeIsVisible$().subscribe(visible => setIsChromeVisible(visible));
    if (lastSavedId && title) {
      chromeRecentlyAccessed.add((0, _dashboard_constants.getFullEditPath)(lastSavedId, viewMode === _public2.ViewMode.EDIT), title, lastSavedId);
    }
    return () => subscription.unsubscribe();
  }, [allowByValueEmbeddables, chromeRecentlyAccessed, getChromeIsVisible$, lastSavedId, viewMode, title]);

  /**
   * Set breadcrumbs to dashboard title when dashboard's title or view mode changes
   */
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: (0, _dashboard_app_strings.getDashboardBreadcrumb)(),
      'data-test-subj': 'dashboardListingBreadcrumb',
      onClick: () => {
        redirectTo({
          destination: 'listing'
        });
      }
    }, {
      text: dashboardTitle
    }]);
  }, [setBreadcrumbs, redirectTo, dashboardTitle]);

  /**
   * Build app leave handler whenever hasUnsavedChanges changes
   */
  (0, _react.useEffect)(() => {
    onAppLeave(actions => {
      if (viewMode === _public2.ViewMode.EDIT && hasUnsavedChanges && !getStateTransfer().isTransferInProgress) {
        return actions.confirm(_dashboard_app_strings.leaveConfirmStrings.getLeaveSubtitle(), _dashboard_app_strings.leaveConfirmStrings.getLeaveTitle());
      }
      return actions.default();
    });
    return () => {
      // reset on app leave handler so leaving from the listing page doesn't trigger a confirmation
      onAppLeave(actions => actions.default());
    };
  }, [onAppLeave, getStateTransfer, hasUnsavedChanges, viewMode]);
  const {
    viewModeTopNavConfig,
    editModeTopNavConfig
  } = (0, _use_dashboard_menu_items.useDashboardMenuItems)({
    redirectTo,
    isLabsShown,
    setIsLabsShown
  });
  const visibilityProps = (0, _react.useMemo)(() => {
    const shouldShowNavBarComponent = forceShow => (forceShow || isChromeVisible) && !fullScreenMode;
    const shouldShowFilterBar = forceHide => !forceHide && (filterManager.getFilters().length > 0 || !fullScreenMode);
    const showTopNavMenu = shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowTopNavMenu));
    const showQueryInput = shouldShowNavBarComponent(Boolean((embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowQueryInput) || viewMode === _public2.ViewMode.PRINT));
    const showDatePicker = shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowDatePicker));
    const showFilterBar = shouldShowFilterBar(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceHideFilterBar));
    const showQueryBar = showQueryInput || showDatePicker || showFilterBar;
    const showSearchBar = showQueryBar || showFilterBar;
    return {
      showTopNavMenu,
      showSearchBar,
      showFilterBar,
      showQueryInput,
      showDatePicker
    };
  }, [embedSettings, filterManager, fullScreenMode, isChromeVisible, viewMode]);
  (0, _useUnmount.default)(() => {
    dashboard.clearOverlays();
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboardTopNav"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "dashboardTitle",
    className: "euiScreenReaderOnly",
    ref: dashboardTitleRef,
    tabIndex: -1
  }, `${(0, _dashboard_app_strings.getDashboardBreadcrumb)()} - ${dashboardTitle}`), /*#__PURE__*/_react.default.createElement(TopNavMenu, (0, _extends2.default)({}, visibilityProps, {
    query: query,
    screenTitle: title,
    useDefaultBehaviors: true,
    indexPatterns: allDataViews,
    savedQueryId: savedQueryId,
    showSaveQuery: showSaveQuery,
    appName: _dashboard_constants.LEGACY_DASHBOARD_APP_ID,
    visible: viewMode !== _public2.ViewMode.PRINT,
    setMenuMountPoint: embedSettings || fullScreenMode ? undefined : setHeaderActionMenu,
    className: fullScreenMode ? 'kbnTopNavMenu-isFullScreen' : undefined,
    config: visibilityProps.showTopNavMenu ? viewMode === _public2.ViewMode.EDIT ? editModeTopNavConfig : viewModeTopNavConfig : undefined,
    badges: hasUnsavedChanges && viewMode === _public2.ViewMode.EDIT ? [{
      'data-test-subj': 'dashboardUnsavedChangesBadge',
      badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeText(),
      title: '',
      color: 'warning',
      toolTipProps: {
        content: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeToolTipContent(),
        position: 'bottom'
      }
    }] : undefined,
    onQuerySubmit: (_payload, isUpdate) => {
      if (isUpdate === false) {
        dashboard.forceRefresh();
      }
    },
    onSavedQueryIdChange: newId => dashboard.dispatch.setSavedQueryId(newId)
  })), viewMode !== _public2.ViewMode.PRINT && isLabsEnabled && isLabsShown ? /*#__PURE__*/_react.default.createElement(PresentationUtilContextProvider, null, /*#__PURE__*/_react.default.createElement(LabsFlyout, {
    solutions: ['dashboard'],
    onClose: () => setIsLabsShown(false)
  })) : null, viewMode === _public2.ViewMode.EDIT ? /*#__PURE__*/_react.default.createElement(_dashboard_editing_toolbar.DashboardEditingToolbar, null) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }));
}