"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditControlGroupButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EditControlGroupButton = ({
  closePopover,
  controlGroup,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "gear",
    "data-test-subj": "controls-settings-button",
    "aria-label": (0, _dashboard_app_strings.getEditControlGroupButtonTitle)(),
    onClick: () => {
      controlGroup.openEditControlGroupFlyout();
      closePopover();
    }
  }), (0, _dashboard_app_strings.getEditControlGroupButtonTitle)());
};
exports.EditControlGroupButton = EditControlGroupButton;