"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsToolbarButton = ControlsToolbarButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _add_data_control_button = require("./add_data_control_button");
var _add_time_slider_control_button = require("./add_time_slider_control_button");
var _edit_control_group_button = require("./edit_control_group_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ControlsToolbarButton({
  controlGroup
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    ownFocus: true,
    repositionOnScroll: true,
    panelPaddingSize: "none",
    label: (0, _dashboard_app_strings.getControlButtonTitle)(),
    zIndex: Number(euiTheme.levels.header) - 1,
    "data-test-subj": "dashboard-controls-menu-button"
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_add_data_control_button.AddDataControlButton, {
      key: "addControl",
      controlGroup: controlGroup,
      closePopover: closePopover
    }), /*#__PURE__*/_react.default.createElement(_add_time_slider_control_button.AddTimeSliderControlButton, {
      key: "addTimeSliderControl",
      controlGroup: controlGroup,
      closePopover: closePopover
    }), /*#__PURE__*/_react.default.createElement(_edit_control_group_button.EditControlGroupButton, {
      key: "manageControls",
      controlGroup: controlGroup,
      closePopover: closePopover
    })]
  }));
}