"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDashboardAppInNoDataState = exports.DashboardAppNoDataPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageAnalyticsNoData = require("@kbn/shared-ux-page-analytics-no-data");
var _plugin_services = require("../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardAppNoDataPage = ({
  onDataViewCreated
}) => {
  const {
    application,
    data: {
      dataViews
    },
    dataViewEditor,
    http: {
      basePath
    },
    documentationLinks: {
      indexPatternsDocLink,
      kibanaGuideDocLink
    },
    customBranding
  } = _plugin_services.pluginServices.getServices();
  const analyticsServices = {
    coreStart: {
      docLinks: {
        links: {
          kibana: {
            guide: kibanaGuideDocLink
          },
          indexPatterns: {
            introduction: indexPatternsDocLink
          }
        }
      },
      application,
      http: {
        basePath
      },
      customBranding: {
        hasCustomBranding$: customBranding.hasCustomBranding$
      }
    },
    dataViews,
    dataViewEditor
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated
  }));
};
exports.DashboardAppNoDataPage = DashboardAppNoDataPage;
const isDashboardAppInNoDataState = async () => {
  const {
    data: {
      dataViews
    }
  } = _plugin_services.pluginServices.getServices();
  const hasUserDataView = await dataViews.hasData.hasUserDataView().catch(() => false);
  return !hasUserDataView;
};
exports.isDashboardAppInNoDataState = isDashboardAppInNoDataState;