"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardListingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _dashboard_app_no_data = require("../no_data/dashboard_app_no_data");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _get_dashboard_list_item_link = require("./get_dashboard_list_item_link");
var _dashboard_listing = require("../../dashboard_listing/dashboard_listing");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardListingPage = ({
  title,
  redirectTo,
  initialFilter,
  kbnUrlStateStorage
}) => {
  const {
    data: {
      query
    },
    chrome: {
      setBreadcrumbs
    },
    dashboardSavedObject: {
      findDashboards
    }
  } = _plugin_services.pluginServices.getServices();
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let isMounted = true;
    (async () => {
      const isInNoDataState = await (0, _dashboard_app_no_data.isDashboardAppInNoDataState)();
      if (isInNoDataState && isMounted) setShowNoDataPage(true);
    })();
    return () => {
      isMounted = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: (0, _dashboard_app_strings.getDashboardBreadcrumb)()
    }]);
  }, [setBreadcrumbs]);
  (0, _react.useEffect)(() => {
    // syncs `_g` portion of url with query services
    const {
      stop: stopSyncingQueryServiceStateWithUrl
    } = (0, _public2.syncGlobalQueryStateWithUrl)(query, kbnUrlStateStorage);
    if (title) {
      findDashboards.findByTitle(title).then(result => {
        if (!result) return;
        redirectTo({
          destination: 'dashboard',
          id: result.id,
          useReplace: true
        });
      });
    }
    return () => {
      stopSyncingQueryServiceStateWithUrl();
    };
  }, [title, redirectTo, query, kbnUrlStateStorage, findDashboards]);
  const titleFilter = title ? `${title}` : '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showNoDataPage && /*#__PURE__*/_react.default.createElement(_dashboard_app_no_data.DashboardAppNoDataPage, {
    onDataViewCreated: () => setShowNoDataPage(false)
  }), !showNoDataPage && /*#__PURE__*/_react.default.createElement(_dashboard_listing.DashboardListing, {
    useSessionStorageIntegration: true,
    initialFilter: initialFilter !== null && initialFilter !== void 0 ? initialFilter : titleFilter,
    goToDashboard: (id, viewMode) => {
      redirectTo({
        destination: 'dashboard',
        id,
        editMode: viewMode === _public.ViewMode.EDIT
      });
    },
    getDashboardUrl: (id, timeRestore) => {
      return (0, _get_dashboard_list_item_link.getDashboardListItemLink)(kbnUrlStateStorage, id, timeRestore);
    }
  }));
};
exports.DashboardListingPage = DashboardListingPage;