"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardAPIContext = void 0;
exports.DashboardApp = DashboardApp;
exports.useDashboardAPI = void 0;
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _dashboard_app_no_data = require("./no_data/dashboard_app_no_data");
var _sync_dashboard_url_state = require("./url/sync_dashboard_url_state");
var _search_sessions_integration = require("./url/search_sessions_integration");
var _ = require("..");
var _dashboard_constants = require("../dashboard_constants");
var _plugin_services = require("../services/plugin_services");
var _dashboard_top_nav = require("./top_nav/dashboard_top_nav");
var _dashboard_mount_context = require("./hooks/dashboard_mount_context");
var _use_dashboard_outcome_validation = require("./hooks/use_dashboard_outcome_validation");
var _load_dashboard_history_location_state = require("./locator/load_dashboard_history_location_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardAPIContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.DashboardAPIContext = DashboardAPIContext;
const useDashboardAPI = () => {
  const api = (0, _react.useContext)(DashboardAPIContext);
  if (api == null) {
    throw new Error('useDashboardAPI must be used inside DashboardAPIContext');
  }
  return api;
};
exports.useDashboardAPI = useDashboardAPI;
function DashboardApp({
  savedDashboardId,
  embedSettings,
  redirectTo,
  history
}) {
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  (0, _useMount.default)(() => {
    (async () => setShowNoDataPage(await (0, _dashboard_app_no_data.isDashboardAppInNoDataState)()))();
  });
  const [dashboardAPI, setDashboardAPI] = (0, _react.useState)(null);

  /**
   * Unpack & set up dashboard services
   */
  const {
    screenshotMode: {
      isScreenshotMode,
      getScreenshotContext
    },
    coreContext: {
      executionContext
    },
    embeddable: {
      getStateTransfer
    },
    notifications: {
      toasts
    },
    settings: {
      uiSettings
    },
    data: {
      search
    },
    customBranding
  } = _plugin_services.pluginServices.getServices();
  const showPlainSpinner = (0, _useObservable.default)(customBranding.hasCustomBranding$, false);
  const {
    scopedHistory: getScopedHistory
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  (0, _public2.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'app',
    id: savedDashboardId || 'new'
  });
  const kbnUrlStateStorage = (0, _react.useMemo)(() => (0, _public3.createKbnUrlStateStorage)({
    history,
    useHash: uiSettings.get('state:storeInSessionStorage'),
    ...(0, _public3.withNotifyOnErrors)(toasts)
  }), [toasts, history, uiSettings]);

  /**
   * Clear search session when leaving dashboard route
   */
  (0, _react.useEffect)(() => {
    return () => {
      search.session.clear();
    };
  }, [search.session]);

  /**
   * Validate saved object load outcome
   */
  const {
    validateOutcome,
    getLegacyConflictWarning
  } = (0, _use_dashboard_outcome_validation.useDashboardOutcomeValidation)({
    redirectTo
  });

  /**
   * Create options to pass into the dashboard renderer
   */
  const getCreationOptions = (0, _react.useCallback)(() => {
    const searchSessionIdFromURL = (0, _search_sessions_integration.getSearchSessionIdFromURL)(history);
    const getInitialInput = () => {
      const stateFromLocator = (0, _load_dashboard_history_location_state.loadDashboardHistoryLocationState)(getScopedHistory);
      const initialUrlState = (0, _sync_dashboard_url_state.loadAndRemoveDashboardState)(kbnUrlStateStorage);

      // Override all state with URL + Locator input
      return {
        // State loaded from the dashboard app URL and from the locator overrides all other dashboard state.
        ...initialUrlState,
        ...stateFromLocator,
        // if print mode is active, force viewMode.PRINT
        ...(isScreenshotMode() && getScreenshotContext('layout') === 'print' ? {
          viewMode: _public.ViewMode.PRINT
        } : {})
      };
    };
    return Promise.resolve({
      getIncomingEmbeddable: () => getStateTransfer().getIncomingEmbeddablePackage(_dashboard_constants.DASHBOARD_APP_ID, true),
      // integrations
      useControlGroupIntegration: true,
      useSessionStorageIntegration: true,
      useUnifiedSearchIntegration: true,
      unifiedSearchSettings: {
        kbnUrlStateStorage
      },
      useSearchSessionsIntegration: true,
      searchSessionSettings: {
        createSessionRestorationDataProvider: _search_sessions_integration.createSessionRestorationDataProvider,
        sessionIdToRestore: searchSessionIdFromURL,
        sessionIdUrlChangeObservable: (0, _search_sessions_integration.getSessionURLObservable)(history),
        getSearchSessionIdFromURL: () => (0, _search_sessions_integration.getSearchSessionIdFromURL)(history),
        removeSessionIdFromUrl: () => (0, _search_sessions_integration.removeSearchSessionIdFromURL)(kbnUrlStateStorage)
      },
      getInitialInput,
      validateLoadedSavedObject: validateOutcome,
      isEmbeddedExternally: Boolean(embedSettings) // embed settings are only sent if the dashboard URL has `embed=true`
    });
  }, [history, embedSettings, validateOutcome, getScopedHistory, isScreenshotMode, getStateTransfer, kbnUrlStateStorage, getScreenshotContext]);

  /**
   * When the dashboard container is created, or re-created, start syncing dashboard state with the URL
   */
  (0, _react.useEffect)(() => {
    if (!dashboardAPI) return;
    const {
      stopWatchingAppStateInUrl
    } = (0, _sync_dashboard_url_state.startSyncingDashboardUrlState)({
      kbnUrlStateStorage,
      dashboardAPI
    });
    return () => stopWatchingAppStateInUrl();
  }, [dashboardAPI, kbnUrlStateStorage, savedDashboardId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dshAppWrapper"
  }, showNoDataPage && /*#__PURE__*/_react.default.createElement(_dashboard_app_no_data.DashboardAppNoDataPage, {
    onDataViewCreated: () => setShowNoDataPage(false)
  }), !showNoDataPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardAPI && /*#__PURE__*/_react.default.createElement(DashboardAPIContext.Provider, {
    value: dashboardAPI
  }, /*#__PURE__*/_react.default.createElement(_dashboard_top_nav.DashboardTopNav, {
    redirectTo: redirectTo,
    embedSettings: embedSettings
  })), getLegacyConflictWarning === null || getLegacyConflictWarning === void 0 ? void 0 : getLegacyConflictWarning(), /*#__PURE__*/_react.default.createElement(_.DashboardRenderer, {
    ref: setDashboardAPI,
    savedObjectId: savedDashboardId,
    showPlainSpinner: showPlainSpinner,
    getCreationOptions: getCreationOptions
  })));
}