"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplacePanelAction = exports.ACTION_REPLACE_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _open_replace_panel_flyout = require("./open_replace_panel_flyout");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_container = require("../dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_REPLACE_PANEL = 'replacePanel';
exports.ACTION_REPLACE_PANEL = ACTION_REPLACE_PANEL;
function isDashboard(embeddable) {
  return embeddable.type === _dashboard_container.DASHBOARD_CONTAINER_TYPE;
}
class ReplacePanelAction {
  constructor(savedobjectfinder) {
    (0, _defineProperty2.default)(this, "type", ACTION_REPLACE_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_REPLACE_PANEL);
    (0, _defineProperty2.default)(this, "order", 3);
    this.savedobjectfinder = savedobjectfinder;
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return _dashboard_actions_strings.dashboardReplacePanelActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return 'kqlOperand';
  }
  async isCompatible({
    embeddable
  }) {
    if (embeddable.getInput().viewMode) {
      if (embeddable.getInput().viewMode === _public.ViewMode.VIEW) {
        return false;
      }
    }
    return Boolean(embeddable.parent && isDashboard(embeddable.parent));
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    const view = embeddable;
    const dash = embeddable.parent;
    (0, _open_replace_panel_flyout.openReplacePanelFlyout)({
      embeddable: dash,
      savedObjectFinder: this.savedobjectfinder,
      panelToRemove: view
    });
  }
}
exports.ReplacePanelAction = ReplacePanelAction;