"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandPanelAction = exports.ACTION_EXPAND_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/ui-actions-plugin/public");
var _dashboard_container = require("../dashboard_container");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EXPAND_PANEL = 'togglePanel';
exports.ACTION_EXPAND_PANEL = ACTION_EXPAND_PANEL;
function isDashboard(embeddable) {
  return embeddable.type === _dashboard_container.DASHBOARD_CONTAINER_TYPE;
}
function isExpanded(embeddable) {
  if (!embeddable.parent || !isDashboard(embeddable.parent)) {
    throw new _public.IncompatibleActionError();
  }
  return embeddable.id === embeddable.parent.getExpandedPanelId();
}
class ExpandPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "order", 7);
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public.IncompatibleActionError();
    }
    return isExpanded(embeddable) ? _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMinimizeTitle() : _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMaximizeTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public.IncompatibleActionError();
    }
    return isExpanded(embeddable) ? 'minimize' : 'expand';
  }
  async isCompatible({
    embeddable
  }) {
    return Boolean(embeddable.parent && isDashboard(embeddable.parent));
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public.IncompatibleActionError();
    }
    const newValue = isExpanded(embeddable) ? undefined : embeddable.id;
    embeddable.parent.setExpandedPanelId(newValue);
    if (!newValue) {
      embeddable.parent.setScrollToPanelId(embeddable.id);
    }
  }
}
exports.ExpandPanelAction = ExpandPanelAction;