"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClonePanelAction = exports.ACTION_CLONE_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _uuid = require("uuid");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _dashboard_panel_placement = require("../dashboard_container/component/panel/dashboard_panel_placement");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_container = require("../dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_CLONE_PANEL = 'clonePanel';
exports.ACTION_CLONE_PANEL = ACTION_CLONE_PANEL;
class ClonePanelAction {
  constructor(savedObjects) {
    (0, _defineProperty2.default)(this, "type", ACTION_CLONE_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_CLONE_PANEL);
    (0, _defineProperty2.default)(this, "order", 45);
    (0, _defineProperty2.default)(this, "toastsService", void 0);
    this.savedObjects = savedObjects;
    ({
      notifications: {
        toasts: this.toastsService
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return _dashboard_actions_strings.dashboardClonePanelActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return 'copy';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$getInput;
    return Boolean(!(0, _public.isErrorEmbeddable)(embeddable) && ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _public.ViewMode.VIEW && embeddable.getRoot() && embeddable.getRoot().isContainer && embeddable.getRoot().type === _dashboard_container.DASHBOARD_CONTAINER_TYPE && embeddable.getOutput().editable);
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    const dashboard = embeddable.getRoot();
    const panelToClone = dashboard.getInput().panels[embeddable.id];
    if (!panelToClone) {
      throw new _public.PanelNotFoundError();
    }
    dashboard.showPlaceholderUntil(this.cloneEmbeddable(panelToClone, embeddable), _dashboard_panel_placement.placePanelBeside, {
      width: panelToClone.gridData.w,
      height: panelToClone.gridData.h,
      currentPanels: dashboard.getInput().panels,
      placeBesideId: panelToClone.explicitInput.id,
      scrollToPanel: true
    });
  }
  async getCloneTitle(embeddable, rawTitle) {
    if (rawTitle === '') return ''; // If

    const clonedTag = _dashboard_actions_strings.dashboardClonePanelActionStrings.getClonedTag();
    const cloneRegex = new RegExp(`\\(${clonedTag}\\)`, 'g');
    const cloneNumberRegex = new RegExp(`\\(${clonedTag} [0-9]+\\)`, 'g');
    const baseTitle = rawTitle.replace(cloneNumberRegex, '').replace(cloneRegex, '').trim();
    let similarTitles;
    if ((0, _public.isReferenceOrValueEmbeddable)(embeddable) || !_lodash.default.has(embeddable.getExplicitInput(), 'savedObjectId')) {
      const dashboard = embeddable.getRoot();
      similarTitles = _lodash.default.filter(await dashboard.getPanelTitles(), title => {
        return title.startsWith(baseTitle);
      });
    } else {
      const perPage = 10;
      const similarSavedObjects = await this.savedObjects.client.find({
        type: embeddable.type,
        perPage,
        fields: ['title'],
        searchFields: ['title'],
        search: `"${baseTitle}"`
      });
      if (similarSavedObjects.total <= perPage) {
        similarTitles = similarSavedObjects.savedObjects.map(savedObject => {
          return savedObject.get('title');
        });
      } else {
        similarTitles = [baseTitle + ` (${clonedTag} ${similarSavedObjects.total - 1})`];
      }
    }
    const cloneNumbers = _lodash.default.map(similarTitles, title => {
      if (title.match(cloneRegex)) return 0;
      const cloneTag = title.match(cloneNumberRegex);
      return cloneTag ? parseInt(cloneTag[0].replace(/[^0-9.]/g, ''), 10) : -1;
    });
    const similarBaseTitlesCount = _lodash.default.max(cloneNumbers) || 0;
    return similarBaseTitlesCount < 0 ? baseTitle + ` (${clonedTag})` : baseTitle + ` (${clonedTag} ${similarBaseTitlesCount + 1})`;
  }
  async addCloneToLibrary(embeddable, objectIdToClone) {
    const savedObjectToClone = await this.savedObjects.client.get(embeddable.type, objectIdToClone);

    // Clone the saved object
    const newTitle = await this.getCloneTitle(embeddable, savedObjectToClone.attributes.title);
    const clonedSavedObject = await this.savedObjects.client.create(embeddable.type, {
      ..._lodash.default.cloneDeep(savedObjectToClone.attributes),
      title: newTitle
    }, {
      references: _lodash.default.cloneDeep(savedObjectToClone.references)
    });
    return clonedSavedObject.id;
  }
  async cloneEmbeddable(panelToClone, embeddable) {
    let panelState;
    if ((0, _public.isReferenceOrValueEmbeddable)(embeddable)) {
      const newTitle = await this.getCloneTitle(embeddable, embeddable.getTitle() || '');
      panelState = {
        type: embeddable.type,
        explicitInput: {
          ...(await embeddable.getInputAsValueType()),
          id: (0, _uuid.v4)(),
          title: newTitle,
          hidePanelTitles: panelToClone.explicitInput.hidePanelTitles
        }
      };
    } else {
      panelState = {
        type: embeddable.type,
        explicitInput: {
          ...panelToClone.explicitInput,
          id: (0, _uuid.v4)()
        }
      };
      if (panelToClone.explicitInput.savedObjectId) {
        const clonedSavedObjectId = await this.addCloneToLibrary(embeddable, panelToClone.explicitInput.savedObjectId);
        panelState.explicitInput.savedObjectId = clonedSavedObjectId;
      }
    }
    this.toastsService.addSuccess({
      title: _dashboard_actions_strings.dashboardClonePanelActionStrings.getSuccessMessage(),
      'data-test-subj': 'addObjectToContainerSuccess'
    });
    return panelState;
  }
}
exports.ClonePanelAction = ClonePanelAction;